/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class MAExplosion
extends Explosion {
    private static final ExplosionContext EXPLOSION_DAMAGE_CALCULATOR = new ExplosionContext();
    private final boolean fire;
    private final Explosion.Mode blockInteraction;
    private final Random random = new Random();
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    private final float damage;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionContext damageCalculator;
    private final List<BlockPos> toBlow = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> hitPlayers = Maps.newHashMap();
    private final Vector3d position;

    public static MAExplosion make(@Nullable LivingEntity caster, ServerWorld world, double x, double y, double z, float radius, float damage, Explosion.Mode mode) {
        MAExplosion explosion = new MAExplosion((World)world, (Entity)caster, DamageSource.func_188405_b((LivingEntity)caster), new ExplosionContext(), x, y, z, radius, true, mode, damage);
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (mode == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity serverplayerentity : world.func_217369_A()) {
            if (!(serverplayerentity.func_70092_e(x, y, x) < 4096.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(x, y, z, radius, explosion.func_180343_e(), explosion.func_77277_b().get(serverplayerentity)));
        }
        world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, (float)(0.9 + Math.random() * 0.2), (float)(0.9 + Math.random() * 0.2));
        return explosion;
    }

    public MAExplosion(World level, @Nullable Entity source, @Nullable DamageSource damagesource, @Nullable ExplosionContext damageCalculator, double x, double y, double z, float radius, boolean doFire, Explosion.Mode interactionMode, float damage) {
        super(level, source, damagesource, damageCalculator, x, y, z, radius, doFire, interactionMode);
        this.damage = damage;
        this.level = level;
        this.source = source;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.fire = doFire;
        this.blockInteraction = interactionMode;
        this.damageSource = damagesource == null ? DamageSource.func_94539_a((Explosion)this) : damagesource;
        this.damageCalculator = damageCalculator == null ? this.makeDamageCalculator(source) : damageCalculator;
        this.position = new Vector3d(this.x, this.y, this.z);
    }

    private ExplosionContext makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityExplosionContext(entity);
    }

    public static float getSeenPercent(Vector3d vector, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.func_219803_d((double)f, (double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72336_d);
                        Vector3d vector3d = new Vector3d(d5 + d3, d6 = MathHelper.func_219803_d((double)f1, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72337_e), (d7 = MathHelper.func_219803_d((double)f2, (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72334_f)) + d4);
                        if (entity.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.level.func_180495_p(blockpos);
                        Optional optional = this.damageCalculator.func_230312_a_((Explosion)this, (IBlockReader)this.level, blockpos, blockstate, fluidstate = this.level.func_204610_c(blockpos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.func_230311_a_((Explosion)this, (IBlockReader)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll(set);
        float f2 = this.radius * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f2 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f2 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f2 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f2 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f2 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f2 + 1.0));
        List list = this.level.func_72839_b(this.source, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.level, (Explosion)this, (List)list, (double)f2);
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(vector3d)) / f2)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.x) * d5 + (d7 = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - this.y) * d7 + (d9 = entity.func_226281_cx_() - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = MAExplosion.getSeenPercent(vector3d, entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), this.damage);
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.hitPlayers.put(playerentity, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean p_77279_1_) {
        boolean flag;
        if (this.level.field_72995_K) {
            this.level.func_184134_a(this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.level.field_73012_v.nextFloat() - this.level.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.blockInteraction != Explosion.Mode.NONE;
        if (p_77279_1_) {
            if (!(this.radius < 2.0f) && flag) {
                this.level.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.toBlow, this.level.field_73012_v);
            for (BlockPos blockpos : this.toBlow) {
                BlockState blockstate = this.level.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)this.level, blockpos)) continue;
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.level.func_217381_Z().func_76320_a("explosion_blocks");
                if (blockstate.canDropFromExplosion((IBlockReader)this.level, blockpos, (Explosion)this) && this.level instanceof ServerWorld) {
                    TileEntity tileentity = blockstate.hasTileEntity() ? this.level.func_175625_s(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.level).func_216023_a(this.level.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.source);
                    if (this.blockInteraction == Explosion.Mode.DESTROY) {
                        lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.func_215693_a(lootcontext$builder).forEach(p_229977_2_ -> MAExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.func_180495_p(blockpos2).func_196958_f() || !this.level.func_180495_p(blockpos2.func_177977_b()).func_200015_d((IBlockReader)this.level, blockpos2.func_177977_b())) continue;
                this.level.func_175656_a(blockpos2, AbstractFireBlock.func_235326_a_((IBlockReader)this.level, (BlockPos)blockpos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)p_229976_1_, (int)16);
            p_229976_0_.set(j, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!p_229976_1_.func_190926_b()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)p_229976_1_, (Object)p_229976_2_));
    }

    public DamageSource func_199591_b() {
        return this.damageSource;
    }

    public Map<PlayerEntity, Vector3d> func_77277_b() {
        return this.hitPlayers;
    }

    @Nullable
    public LivingEntity func_94613_c() {
        Entity entity;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof TNTEntity) {
            return ((TNTEntity)this.source).func_94083_c();
        }
        if (this.source instanceof LivingEntity) {
            return (LivingEntity)this.source;
        }
        if (this.source instanceof ProjectileEntity && (entity = ((ProjectileEntity)this.source).func_234616_v_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void func_180342_d() {
        this.toBlow.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.toBlow;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.source;
    }

    public static enum Mode {
        NONE,
        BREAK,
        DESTROY;

    }
}

