/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.ma.entities.EntityInit;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class RisingBlockEntity
extends FallingBlockEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> MAXAGE = EntityDataManager.func_187226_a(RisingBlockEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public RisingBlockEntity(World worldIn, double x, double y, double z, BlockState fallingBlockState) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)EntityInit.RISING_BLOCK_ENTITY.get()), worldIn);
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.func_184530_a(this.func_233580_cy_());
        this.field_175132_d = fallingBlockState;
        this.func_189654_d(true);
        this.func_213293_j(0.0, 0.5, 0.0);
        this.field_70160_al = true;
    }

    public RisingBlockEntity(EntityType<? extends FallingBlockEntity> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        if (this.field_175132_d.func_196958_f()) {
            this.func_70106_y();
        } else {
            Block block = this.field_175132_d.func_177230_c();
            if (this.field_145812_b++ == 0) {
                BlockPos blockpos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(blockpos).func_203425_a(block)) {
                    if (block instanceof DoorBlock) {
                        BlockState below = this.field_70170_p.func_180495_p(blockpos.func_177977_b());
                        if (below.func_177230_c() == block) {
                            this.field_70170_p.func_180501_a(blockpos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 16);
                        }
                        this.field_70170_p.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 16);
                    } else {
                        this.field_70170_p.func_175655_b(blockpos, false);
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            List entitiesAbove = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.0, 1.0, 0.0));
            entitiesAbove.forEach(p -> this.moveEntity((Entity)p));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                BlockPos myPosition = this.func_233580_cy_();
                if (this.field_145812_b > (Integer)this.field_70180_af.func_187225_a(MAXAGE)) {
                    this.field_70124_G = true;
                }
                if (!this.field_70124_G) {
                    if (!(this.field_70170_p.field_72995_K || (this.field_145812_b <= 100 || myPosition.func_177956_o() >= 1 && myPosition.func_177956_o() <= 256) && this.field_145812_b <= 600)) {
                        if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    this.restoreBlock(myPosition, block);
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    private void moveEntity(Entity p) {
        p.func_230245_c_(true);
        if (p.func_213322_ci().field_72448_b < this.func_213322_ci().field_72448_b) {
            p.func_213293_j(p.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, p.func_213322_ci().field_72449_c);
        }
    }

    private void restoreBlock(BlockPos myPosition, Block block) {
        BlockState blockstate = this.field_70170_p.func_180495_p(myPosition);
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, 0.5, 0.7));
        if (!blockstate.func_203425_a(Blocks.field_196603_bb)) {
            this.func_70106_y();
            if (block instanceof DoorBlock && this.field_175132_d.func_235901_b_((Property)DoorBlock.field_176523_O)) {
                this.field_175132_d = (BlockState)this.field_175132_d.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER);
            }
            boolean flag2 = blockstate.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, myPosition, Direction.UP, ItemStack.field_190927_a, Direction.UP));
            boolean flag4 = this.field_175132_d.func_196955_c((IWorldReader)this.field_70170_p, myPosition);
            if (flag2 && flag4) {
                if (this.field_175132_d.func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(myPosition).func_206886_c() == Fluids.field_204546_a) {
                    this.field_175132_d = (BlockState)this.field_175132_d.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                }
                if (this.field_70170_p.func_180501_a(myPosition, this.field_175132_d, 3)) {
                    TileEntity tileentity;
                    if (block instanceof FallingBlock) {
                        ((FallingBlock)block).func_176502_a_(this.field_70170_p, myPosition, this.field_175132_d, blockstate, (FallingBlockEntity)this);
                    }
                    if (this.field_145810_d != null && this.field_175132_d.hasTileEntity() && (tileentity = this.field_70170_p.func_175625_s(myPosition)) != null) {
                        CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                        for (String s : this.field_145810_d.func_150296_c()) {
                            INBT inbt = this.field_145810_d.func_74781_a(s);
                            if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                            compoundnbt.func_218657_a(s, inbt.func_74737_b());
                        }
                        tileentity.func_230337_a_(this.field_175132_d, compoundnbt);
                        tileentity.func_70296_d();
                    }
                } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)block);
                }
            } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.func_199703_a((IItemProvider)block);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAXAGE, (Object)50);
    }

    public void setMaxAge(int age) {
        this.field_70180_af.func_187227_b(MAXAGE, (Object)age);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(Block.func_196246_j((BlockState)this.func_195054_l()));
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int stateId = additionalData.readInt();
        this.field_175132_d = Block.func_196257_b((int)stateId);
        if (this.field_175132_d == null) {
            this.field_175132_d = Blocks.field_150354_m.func_176223_P();
        }
    }
}

