/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.effects.interfaces.IInputDisable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InputDisabler {
    public static int getDisableInputMask(LivingEntity entity) {
        int mask = 0;
        for (EffectInstance effect : entity.func_70651_bq()) {
            if (!(effect.func_188419_a() instanceof IInputDisable)) continue;
            mask |= ((IInputDisable)effect.func_188419_a()).getDisableMask();
        }
        return mask;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getPlayer());
        if ((mask & IInputDisable.InputMask.LEFT_CLICK.mask()) != 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getPlayer());
        if ((mask & IInputDisable.InputMask.RIGHT_CLICK.mask()) != 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getPlayer());
        if ((mask & IInputDisable.InputMask.RIGHT_CLICK.mask()) != 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getPlayer());
        if ((mask & IInputDisable.InputMask.RIGHT_CLICK.mask()) != 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getPlayer());
        if ((mask & IInputDisable.InputMask.RIGHT_CLICK.mask()) != 0) {
            event.setCanceled(true);
        }
    }
}

