/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events.delayed;

import com.ma.events.delayed.IDelayedEvent;
import com.ma.tools.TeleportHelper;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;

public class DelayedDimensionTeleportEvent
implements IDelayedEvent {
    final LivingEntity target;
    final ServerWorld origin;
    final ServerWorld destination;

    public DelayedDimensionTeleportEvent(LivingEntity entity, ServerWorld origin, ServerWorld destination) {
        this.origin = origin;
        this.destination = destination;
        this.target = entity;
    }

    @Override
    public boolean tick() {
        this.teleportOnSchedule();
        return true;
    }

    @Override
    public String getID() {
        return "";
    }

    private void teleportOnSchedule() {
        Vector3d targetPosition = this.calculateDimensionDifferencePosition(this.target.func_213303_ch(), this.origin, this.destination);
        this.clearTeleportArea(this.destination, new BlockPos(targetPosition));
        TeleportHelper.teleportEntity((Entity)this.target, (RegistryKey<World>)this.destination.func_234923_W_(), targetPosition);
    }

    private void clearTeleportArea(ServerWorld world, BlockPos origin) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos target = origin.func_177982_a(i, j, k);
                    if (world.func_175623_d(target) || world.func_175625_s(target) != null || world.func_180495_p(target).func_177230_c() == Blocks.field_150357_h) continue;
                    world.func_175656_a(target, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    protected Vector3d calculateDimensionDifferencePosition(Vector3d origin, ServerWorld from, ServerWorld to) {
        WorldBorder worldborder = to.func_175723_af();
        double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
        double scale = DimensionType.func_242715_a((DimensionType)from.func_230315_m_(), (DimensionType)to.func_230315_m_());
        BlockPos scaledPos = new BlockPos(MathHelper.func_151237_a((double)(origin.field_72450_a * scale), (double)minX, (double)maxX), MathHelper.func_151237_a((double)origin.field_72448_b, (double)5.0, (double)(to.func_217301_I() - 2)), MathHelper.func_151237_a((double)(origin.field_72449_c * scale), (double)minZ, (double)maxZ));
        BlockPos searchPos = new BlockPos((Vector3i)scaledPos);
        while (!to.func_175623_d(searchPos) && searchPos.func_177956_o() < to.func_217301_I() - 2) {
            searchPos = searchPos.func_177984_a();
        }
        while (to.func_175623_d(searchPos.func_177977_b()) && searchPos.func_177956_o() > 5) {
            searchPos = searchPos.func_177977_b();
        }
        scaledPos = searchPos;
        return new Vector3d((double)scaledPos.func_177958_n() + 0.5, (double)scaledPos.func_177956_o(), (double)scaledPos.func_177952_p() + 0.5);
    }
}

