/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.gui.containers.ContainerInit;
import com.ma.gui.containers.slots.BaseSlot;
import com.ma.gui.containers.slots.ItemFilterSlot;
import com.ma.items.IBagItem;
import com.ma.items.filters.ItemFilterGroup;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerMarkBook
extends Container {
    private IItemHandler inventory;
    private int bagHash;
    private ItemStack bagStack;

    public ContainerMarkBook(int i, PlayerInventory playerInventory) {
        this(i, playerInventory, ((IPlayerMagic)playerInventory.field_70458_d.getCapability(PlayerMagicProvider.MAGIC).orElse(null)).getGrimoireInventory());
    }

    public ContainerMarkBook(int i, PlayerInventory playerInv, Inventory grimoireInv) {
        super(ContainerInit.MARK_BOOK, i);
        this.inventory = new InvWrapper((IInventory)grimoireInv);
        this.bagStack = playerInv.func_70301_a(playerInv.field_70461_c);
        this.bagHash = this.bagStack.hashCode();
        this.initializeSlots(playerInv);
    }

    protected void initializeSlots(PlayerInventory playerInv) {
        for (int k = 0; k < this.slotsPerRow(); ++k) {
            for (int j = 0; j < this.numRows(); ++j) {
                this.func_75146_a((Slot)this.slot(this.inventory, k + j * this.slotsPerRow(), 18 + k * 18, 7 + j * 18));
            }
        }
        int i = (this.numRows() - 4) * 18;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInv, j1 + l * 9 + 9, 48 + j1 * 18, 102 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInv, i1, 48 + i1 * 18, 160 + i));
        }
    }

    public BaseSlot slot(IItemHandler inv, int index, int x, int y) {
        return new ItemFilterSlot(inv, index, x, y, ItemFilterGroup.ANY_MARKING_RUNE);
    }

    protected int slotsPerRow() {
        return 9;
    }

    protected int numRows() {
        return 2;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        try {
            if (this.func_75139_a(slotId).func_75211_c().hashCode() == this.bagHash) {
                return ItemStack.field_190927_a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            playerIn.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.setSyncGrimoire();
                m.forceSync();
            });
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        ItemStack held = player.func_184614_ca();
        return held == this.bagStack && !this.bagStack.func_190926_b() && held.hashCode() == this.bagHash && held.func_77973_b() instanceof IBagItem;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.numRows() * this.slotsPerRow() ? !this.func_75135_a(itemstack1, this.numRows() * this.slotsPerRow(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.numRows() * this.slotsPerRow(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

