/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.entity;

import com.ma.gui.GuiTextures;
import com.ma.gui.base.SearchableGui;
import com.ma.gui.containers.entity.ContainerWanderingWizard;
import com.ma.network.ClientMessageDispatcher;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiWanderingWizard
extends SearchableGui<ContainerWanderingWizard> {
    private boolean hasinitialized = false;
    private ItemStack tooltipStack = ItemStack.field_190927_a;
    private WanderingWizardOffersList list;
    private int selectedRecipeIndex = -1;

    public GuiWanderingWizard(ContainerWanderingWizard screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.tooltipStack = ItemStack.field_190927_a;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.WANDERING_WIZARD);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        GuiWanderingWizard.func_238463_a_((MatrixStack)matrixStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)193, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiWanderingWizard.func_238463_a_((MatrixStack)matrixStack, (int)(i + 40), (int)(j + 193), (float)40.0f, (float)193.0f, (int)176, (int)63, (int)this.field_146999_f, (int)this.field_147000_g);
        if (this.list != null) {
            this.list.func_230430_a_(matrixStack, x, y, partialTicks);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        if (!this.hasinitialized && ((ContainerWanderingWizard)this.field_147002_h).isFinalized()) {
            this.initialize();
        }
        if (!this.tooltipStack.func_190926_b()) {
            this.func_230457_a_(matrixStack, this.tooltipStack, x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    @Override
    protected void searchTermChanged(String newTerm) {
        this.currentSearchTerm = newTerm;
        this.list.clear();
        this.list.reInit(this.currentSearchTerm);
    }

    private void initialize() {
        this.hasinitialized = true;
        this.list = new WanderingWizardOffersList(((ContainerWanderingWizard)this.field_147002_h).getOffers());
        this.field_230705_e_.add(this.list);
        int tbWidth = 130;
        int x = this.field_147003_i + 6;
        int y = this.field_147009_r + 6;
        this.initSearch(x, y, tbWidth, 16);
    }

    private void OnItemClicked(MerchantOffer offer, int index) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.selectedRecipeIndex = index = ((ContainerWanderingWizard)this.field_147002_h).calculateIndexFor(offer, index, this.currentSearchTerm);
        ((ContainerWanderingWizard)this.field_147002_h).setCurrentRecipeIndex(this.selectedRecipeIndex);
        ((ContainerWanderingWizard)this.field_147002_h).setCurrentTradeRecipeItems(this.selectedRecipeIndex);
        ClientMessageDispatcher.sendTradeSelected(index);
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.list._scrolling) {
            return this.list.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class WanderingWizardOffersList
    extends ExtendedList<ItemStackEntry> {
        private boolean _scrolling;
        public boolean _active;
        private final Collection<MerchantOffer> initialOffers;

        public WanderingWizardOffersList(MerchantOffers merchantOffers) {
            super(GuiWanderingWizard.this.field_230706_i_, 244, 141, GuiWanderingWizard.this.field_147009_r + 26, GuiWanderingWizard.this.field_147009_r + 167, 20);
            this._scrolling = false;
            this._active = true;
            this.func_230943_a_(false);
            this.func_230944_a_(false, 20);
            this.field_230675_l_ = GuiWanderingWizard.this.field_147003_i - 2;
            this.field_230674_k_ = this.field_230675_l_ + 250;
            this.initialOffers = merchantOffers;
            this.reInit("");
        }

        private void addItems(Collection<MerchantOffer> offers, BiConsumer<MerchantOffer, Integer> clickHandler) {
            ArrayList<MerchantOffer> segment = new ArrayList<MerchantOffer>();
            int index = 0;
            for (MerchantOffer part : offers) {
                segment.add(part);
                if (segment.size() != 3) continue;
                this.func_230513_b_((AbstractList.AbstractListEntry)new ItemStackEntry(segment, clickHandler, index));
                index += segment.size();
                segment.clear();
            }
            if (segment.size() > 0) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new ItemStackEntry(segment, clickHandler, index));
            }
        }

        public void clear() {
            this.func_230963_j_();
        }

        public void reInit(String searchTerm) {
            this.addItems(this.initialOffers.stream().filter(o -> searchTerm == "" || o.func_222200_d().func_82840_a((PlayerEntity)this.field_230668_b_.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().anyMatch(l -> l.toString().toLowerCase().contains(searchTerm.toLowerCase()))).collect(Collectors.toList()), (o, i) -> GuiWanderingWizard.this.OnItemClicked(o, i));
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (!this._active) {
                return;
            }
            int scrollBarStartX = this.func_230952_d_();
            int scrollBarEndX = scrollBarStartX + 6;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int xPos = this.func_230968_n_();
            int yPos = this.field_230672_i_ - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, xPos, yPos, mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            if (this.func_230955_e_() > 0) {
                int scrollBarHeight = (int)((float)((this.field_230673_j_ - this.field_230672_i_) * (this.field_230673_j_ - this.field_230672_i_)) / (float)this.func_230945_b_());
                scrollBarHeight = MathHelper.func_76125_a((int)scrollBarHeight, (int)32, (int)(this.field_230673_j_ - this.field_230672_i_ - 8));
                int top = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - scrollBarHeight) / this.func_230955_e_() + this.field_230672_i_;
                if (top < this.field_230672_i_) {
                    top = this.field_230672_i_;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)this.field_230673_j_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)this.field_230673_j_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)this.field_230672_i_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)this.field_230672_i_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)(top + scrollBarHeight), 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)(top + scrollBarHeight), 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)top, 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)top, 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)(top + scrollBarHeight - 1), 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)(scrollBarEndX - 1), (double)(top + scrollBarHeight - 1), 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)(scrollBarEndX - 1), (double)top, 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)top, 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.WANDERING_WIZARD);
            int i = GuiWanderingWizard.this.field_147003_i;
            int j = GuiWanderingWizard.this.field_147009_r;
            this.func_238474_b_(matrixStack, i, j, 0, 0, GuiWanderingWizard.this.field_146999_f, 26);
            this.func_238474_b_(matrixStack, i, j + 167, 0, 167, GuiWanderingWizard.this.field_146999_f, 26);
        }

        @Nullable
        protected final ItemStackEntry getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.func_230968_n_();
            int upperXBound = lowerXBound + this.func_230949_c_();
            int adjustedY = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) + (int)this.func_230966_l_();
            int index = adjustedY / this.field_230669_c_;
            if (index >= 0 && adjustedY >= 0 && index < this.func_230965_k_() && mouseX < (double)this.func_230952_d_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (ItemStackEntry)((Object)this.func_231039_at__().get(index));
            }
            return null;
        }

        protected int func_230952_d_() {
            return this.func_230968_n_() + this.func_230949_c_();
        }

        protected int func_230962_i_(int p_getRowTop_1_) {
            return this.field_230672_i_ - (int)this.func_230966_l_() + p_getRowTop_1_ * this.field_230669_c_;
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        protected void func_230947_b_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.func_230947_b_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.func_230952_d_() && p_updateScrollingState_1_ < (double)(this.func_230952_d_() + 6);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (!this._active) {
                return false;
            }
            this.func_230947_b_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.func_231047_b_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            ItemStackEntry e = this.getEntryAtPos(p_mouseClicked_1_, p_mouseClicked_3_);
            if (e != null) {
                if (e.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                    e.func_231049_c__(true);
                    return true;
                }
            } else if (p_mouseClicked_5_ == 0) {
                this.func_231037_b__(true);
                return true;
            }
            return this._scrolling;
        }

        public int func_230955_e_() {
            return Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
        }

        public void setSelected(@Nullable ItemStackEntry selected) {
            super.func_241215_a_((AbstractList.AbstractListEntry)selected);
        }

        @OnlyIn(value=Dist.CLIENT)
        public class ItemStackEntry
        extends ExtendedList.AbstractListEntry<ItemStackEntry> {
            private Collection<MerchantOffer> items;
            private int spacing = 83;
            private MerchantOffer _hoveredComponent;
            private BiConsumer<MerchantOffer, Integer> _clickHandler;
            private int index;
            private int hoveredIndex;

            public ItemStackEntry(Collection<MerchantOffer> parts, BiConsumer<MerchantOffer, Integer> clickHandler, int index) {
                this.items = new ArrayList<MerchantOffer>(parts);
                this._hoveredComponent = null;
                this.index = index;
                this._clickHandler = clickHandler;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                Minecraft m = Minecraft.func_71410_x();
                ItemRenderer r = m.func_175599_af();
                for (MerchantOffer part : this.items) {
                    if (part == null) continue;
                    int x = 7 + left + i++ * this.spacing;
                    int y = top + 4;
                    m.func_110434_K().func_110577_a(GuiTextures.WANDERING_WIZARD);
                    GuiWanderingWizard.this.func_238474_b_(matrixStack, x, y, 16, 238, 18, 18);
                    GuiWanderingWizard.this.func_238474_b_(matrixStack, x + 18, y, 16, 238, 18, 18);
                    GuiWanderingWizard.this.func_238474_b_(matrixStack, x + 37, y + 3, 0, 246, 16, 10);
                    GuiWanderingWizard.this.func_238474_b_(matrixStack, x + 54, y, 16, 238, 18, 18);
                    r.func_175042_a(part.func_222218_a(), x + 1, y + 1);
                    r.func_175042_a(part.func_222202_c(), x + 19, y + 1);
                    r.func_175042_a(part.func_222200_d(), x + 55, y + 1);
                    if (!isHovered || mouseX < x || mouseX > x + this.spacing) continue;
                    GuiWanderingWizard.this.tooltipStack = part.func_222200_d();
                    this._hoveredComponent = part;
                    this.hoveredIndex = i - 1;
                }
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                WanderingWizardOffersList.this.setSelected(this);
                if (this._clickHandler != null && this._hoveredComponent != null) {
                    this._clickHandler.accept(this._hoveredComponent, this.index + this.hoveredIndex);
                }
                return true;
            }
        }
    }
}

