/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.api.capabilities.Faction;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.ICyclingRecipeRenderer;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.eldrin.EldrinAltarRecipe;
import com.ma.tools.MATags;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeEldrinAltar
extends RecipeRendererBase
implements ICyclingRecipeRenderer<RecipeEldrinAltar> {
    private EldrinAltarRecipe[] patterns;

    public RecipeEldrinAltar(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<EldrinAltarRecipe> patternList = new ArrayList<EldrinAltarRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional<IRecipe<?>> pattern = this.resolveRecipe(rLoc);
            if (!pattern.isPresent() || !(pattern.get() instanceof EldrinAltarRecipe)) continue;
            patternList.add((EldrinAltarRecipe)pattern.get());
        }
        this.patterns = patternList.toArray(new EldrinAltarRecipe[0]);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional<IRecipe<?>> pattern = this.resolveRecipe(recipeLocation);
        this.patterns = pattern.isPresent() && pattern.get() instanceof EldrinAltarRecipe ? new EldrinAltarRecipe[]{(EldrinAltarRecipe)pattern.get()} : null;
    }

    private Optional<? extends IRecipe<?>> resolveRecipe(ResourceLocation recipeLocation) {
        if (recipeLocation.func_110624_b().equals("mana-and-artifice") && !recipeLocation.func_110623_a().startsWith("eldrin_altar/")) {
            recipeLocation = new ResourceLocation(recipeLocation.func_110624_b(), "eldrin_altar/" + recipeLocation.func_110623_a());
        }
        return this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return null;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        List<Object> items;
        int index = this.getIndex();
        if (this.patterns.length == 0) {
            return;
        }
        EldrinAltarRecipe pattern = this.patterns[index];
        if (pattern == null) {
            return;
        }
        int cX = x + this.field_230688_j_ / 2 - 8;
        int cY = y + this.field_230689_k_ / 2;
        float radians = -1.5707964f;
        float radianStep = (float)(Math.PI * 2 / (double)Math.max(pattern.getRequiredItems().length - 1, 1));
        int ingredDist = 60;
        int affStep = 45;
        int powerCount = pattern.getPowerRequirements().size() - 1;
        int affX = cX - (int)Math.floor((float)powerCount / 2.0f * (float)affStep);
        int affY = y + this.field_230689_k_ - 30;
        FontRenderer fr = this.minecraft.field_71466_p;
        ItemStack output = pattern.func_77571_b();
        this.renderItemStack(output, cX, y + 40);
        for (int i = 1; i < pattern.getRequiredItems().length; ++i) {
            items = MATags.smartLookupItem(pattern.getRequiredItems()[i]).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList());
            if (items == null || items.size() == 0) continue;
            int ingredX = cX + (int)Math.round(Math.cos(radians) * (double)ingredDist);
            int ingredY = cY + (int)Math.round(Math.sin(radians) * (double)ingredDist);
            this.renderItemStack(items, ingredX, ingredY);
            GuiRenderUtils.gradientline2d(cX + 8, cY + 8, ingredX + 8, ingredY + 8, 0.0f, pattern.getColorOne(), pattern.getColorTwo());
            radians += radianStep;
        }
        items = MATags.smartLookupItem(pattern.getRequiredItems()[0]).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList());
        if (items == null || items.size() == 0) {
            return;
        }
        this.renderItemStack(items, cX, cY);
        TranslationTextComponent wellspringPowerReq = new TranslationTextComponent("gui.mana-and-artifice.wellspring-power");
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)wellspringPowerReq, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)wellspringPowerReq) / 2), (float)(affY - 15), ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        GuiRenderUtils.gradientline2d(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)wellspringPowerReq) / 2, affY - 5, x + this.field_230688_j_ / 2 + this.minecraft.field_71466_p.func_238414_a_((ITextProperties)wellspringPowerReq) / 2, affY - 5, 0.0f, pattern.getColorOne(), pattern.getColorTwo());
        MutableInt count = new MutableInt(0);
        pattern.getPowerRequirements().forEach((a, v) -> {
            ItemStack guiStack = GuiTextures.affinityIcons.get(a);
            int rX = affX + count.getAndIncrement() * affStep;
            this.renderItemStack(guiStack, rX, affY);
            String vText = String.format("%.0f", v);
            fr.func_238421_b_(matrixStack, vText, (float)(rX - 4 + fr.func_78256_a(vText) / 2), (float)(affY + 16), ColorHelper.PackedColor.func_233006_a_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]));
        });
        int tier = pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        TranslationTextComponent name = new TranslationTextComponent(pattern.func_77571_b().func_77977_a().toString());
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        int stringWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name);
        int textX = x + this.field_230688_j_ / 2 - stringWidth / 2;
        int textY = y + 5;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), (float)(y + 15), color);
        if (pattern.getFactionRequirement() != Faction.NONE) {
            int xPadding = 3;
            this.renderFactionIcon(matrixStack, pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        if (this.patterns == null) {
            return 1;
        }
        int minTier = 5;
        for (EldrinAltarRecipe pattern : this.patterns) {
            if (pattern.getTier() >= minTier) continue;
            minTier = pattern.getTier();
        }
        return minTier;
    }

    @Override
    public int countRecipes() {
        return this.patterns.length;
    }
}

