/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.multiblock.MultiblockDefinition;
import com.ma.tools.render.MultiblockRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeMaterialsList
extends RecipeRendererBase {
    private MultiblockDefinition _recipe;
    private List<List<ItemStack>> _ingredients;
    private static final int ITEMSTACK_WIDTH = 16;
    private boolean visualizeHovered = false;

    public RecipeMaterialsList(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this._recipe == null) {
            return;
        }
        if (this._ingredients == null) {
            this._ingredients = this._recipe.getBlocksList((World)this.minecraft.field_71441_e);
        }
        if (this._ingredients == null) {
            return;
        }
        int rX = 16;
        this.minecraft.field_71466_p.getClass();
        int rY = y + 35 + 9;
        int column_width = 24;
        for (List<ItemStack> stacks : this._ingredients) {
            this.renderItemStack(stacks, x + rX, rY);
            if ((rX += 16 + column_width) < this.field_230688_j_ - 16 - column_width) continue;
            rY += 20;
            rX = 16;
        }
        int tier = this._recipe.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        IFormattableTextComponent name = new TranslationTextComponent("mana-and-artifice:multiblock_recipe").func_230529_a_((ITextComponent)new TranslationTextComponent(this._recipe.func_199560_c().toString()));
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        int tierWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt);
        int tierX = x + this.field_230688_j_ / 2 - tierWidth / 2;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name) / 2), (float)(y + 10), ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)tierX, (float)(y + 20), color);
        int n = x + this.field_230688_j_ / 2;
        this.minecraft.field_71466_p.getClass();
        this.drawVisualizeButton(matrixStack, n, y + 20 + 9, mouseX, mouseY);
    }

    private void drawVisualizeButton(MatrixStack stack, int x, int y, int mouseX, int mouseY) {
        this.minecraft.field_71466_p.getClass();
        int width = 9;
        this.minecraft.field_71466_p.getClass();
        int height = 9;
        this.minecraft.func_110434_K().func_110577_a(GuiTextures.VISUALIZE_MULTIBLOCK);
        RecipeMaterialsList.func_238463_a_((MatrixStack)stack, (int)(x -= width / 2), (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        this.visualizeHovered = false;
        if (mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height) {
            this.visualizeHovered = true;
            List<ITextComponent> toolTip = Arrays.asList(new TranslationTextComponent("gui.mana-and-artifice:visualize_multiblock"));
            this.getTooltipFunction().accept(toolTip);
        }
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (this.visualizeHovered) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            MultiblockRenderer.setMultiblock(this._recipe, (ITextComponent)new TranslationTextComponent(this._recipe.func_199560_c().toString()), false);
            this.minecraft.func_147108_a(null);
            return true;
        }
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_BLANK;
    }

    @Override
    protected void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof MultiblockDefinition) {
            this._recipe = (MultiblockDefinition)pattern.get();
        }
    }

    @Override
    public int getTier() {
        return 0;
    }
}

