/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.sections;

import com.google.gson.JsonObject;
import com.ma.guide.interfaces.IEntrySection;
import com.ma.guide.sections.SectionBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ImageSection
extends SectionBase {
    private ResourceLocation imageTextureLocation;
    private int width;
    private int height;
    private int padding = 5;

    @Override
    public Collection<IEntrySection> parse(JsonObject element, int startY, int maxHeight, int maxWidth, int page) {
        this.imageTextureLocation = new ResourceLocation(element.get("location").getAsString());
        this.width = Math.min(element.get("width").getAsInt(), maxWidth);
        this.height = Math.min(element.get("height").getAsInt(), maxHeight);
        if (startY + this.height > maxHeight) {
            this.setPage(page + 1);
        } else {
            this.setPage(page);
        }
        NonNullList output = NonNullList.func_191196_a();
        output.add((Object)this);
        return output;
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y, int maxWidth, int maxHeight) {
        Minecraft m = Minecraft.func_71410_x();
        m.func_110434_K().func_110577_a(this.imageTextureLocation);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x += (maxWidth - this.width) / 2), (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
    }

    @Override
    public int getHeight(int maxHeight) {
        return this.height + this.padding;
    }

    @Override
    public int getWidth(int maxWidth) {
        return this.width;
    }

    @Override
    public boolean newPage() {
        return false;
    }

    @Override
    public void setPadding(int i) {
        this.padding = i;
    }
}

