/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.sections;

import com.google.gson.JsonObject;
import com.ma.guide.interfaces.IEntrySection;
import com.ma.guide.sections.SectionBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ItemSection
extends SectionBase {
    private float scale;
    private ItemStack renderStack;
    private ItemRenderer mcItemRenderer;

    @Override
    public Collection<IEntrySection> parse(JsonObject element, int startY, int maxHeight, int maxWidth, int page) {
        this.setPage(page);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.get("location").getAsString()));
        this.renderStack = item != null ? new ItemStack((IItemProvider)item) : ItemStack.field_190927_a;
        this.scale = element.has("scale") ? Math.min(element.get("scale").getAsFloat(), 3.0f) : 1.0f;
        Minecraft m = Minecraft.func_71410_x();
        this.mcItemRenderer = m.func_175599_af();
        NonNullList output = NonNullList.func_191196_a();
        output.add((Object)this);
        return output;
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y, int maxWidth, int maxHeight) {
        if (this.renderStack.func_190926_b()) {
            return;
        }
        x = (int)((float)x + ((float)maxWidth - 16.0f * this.scale) / 2.0f);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.mcItemRenderer.func_175042_a(this.renderStack, (int)((float)x / this.scale), (int)((float)y / this.scale));
        RenderSystem.popMatrix();
    }

    @Override
    public int getHeight(int maxHeight) {
        return (int)(16.0f * this.scale) + 5;
    }

    @Override
    public int getWidth(int maxWidth) {
        return (int)(16.0f * this.scale);
    }

    @Override
    public boolean newPage() {
        return false;
    }

    @Override
    public void setPadding(int i) {
    }
}

