/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei;

import com.ma.blocks.BlockInit;
import com.ma.gui.base.GuiJEIDisable;
import com.ma.gui.containers.block.ContainerSpectralCraftingTable;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.interop.jei.categories.ArcaneFurnaceRecipeCategory;
import com.ma.interop.jei.categories.EldrinAltarRecipeCategory;
import com.ma.interop.jei.categories.ManaweavingAltarRecipeCategory;
import com.ma.interop.jei.categories.RitualRecipeCategory;
import com.ma.interop.jei.categories.RunescribingRecipeCategory;
import com.ma.interop.jei.categories.RunicAnvilRecipeCategory;
import com.ma.interop.jei.ingredients.ManaweavePatternIngredient;
import com.ma.interop.jei.ingredients.ManaweavePatternIngredientRenderer;
import com.ma.interop.jei.ingredients.ManaweavePatternIngredientType;
import com.ma.interop.jei.ingredients.ManaweavingPatternIngredientHelper;
import com.ma.items.ItemInit;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@JeiPlugin
public class JEIInterop
implements IModPlugin {
    private EldrinAltarRecipeCategory eldrinAltarRecipeCategory;
    private RitualRecipeCategory ritualRecipeCategory;
    private ManaweavingAltarRecipeCategory manaweavingRecipeCategory;
    private ArcaneFurnaceRecipeCategory arcaneFurnaceRecipeCategory;
    private RunicAnvilRecipeCategory runicAnvilRecipeCategory;
    private RunescribingRecipeCategory runescribingRecipeCategory;
    private Minecraft minecraft = Minecraft.func_71410_x();
    public static final ManaweavePatternIngredientRenderer manaweaveIngredientRenderer = new ManaweavePatternIngredientRenderer();
    public static final ManaweavePatternIngredientType MANAWEAVE_PATTERN = new ManaweavePatternIngredientType();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("mana-and-artifice", "jei-integration");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(GuiJEIDisable.class, new IGuiContainerHandler<GuiJEIDisable<?>>(){

            public List<Rectangle2d> getGuiExtraAreas(GuiJEIDisable<?> containerScreen) {
                return containerScreen.getSideWindowBounds();
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.ritualRecipeCategory = new RitualRecipeCategory(guiHelper);
        this.manaweavingRecipeCategory = new ManaweavingAltarRecipeCategory(guiHelper);
        this.arcaneFurnaceRecipeCategory = new ArcaneFurnaceRecipeCategory(guiHelper);
        this.runicAnvilRecipeCategory = new RunicAnvilRecipeCategory(guiHelper);
        this.runescribingRecipeCategory = new RunescribingRecipeCategory(guiHelper);
        this.eldrinAltarRecipeCategory = new EldrinAltarRecipeCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{this.ritualRecipeCategory});
        registration.addRecipeCategories(new IRecipeCategory[]{this.manaweavingRecipeCategory});
        registration.addRecipeCategories(new IRecipeCategory[]{this.arcaneFurnaceRecipeCategory});
        registration.addRecipeCategories(new IRecipeCategory[]{this.runicAnvilRecipeCategory});
        registration.addRecipeCategories(new IRecipeCategory[]{this.runescribingRecipeCategory});
        registration.addRecipeCategories(new IRecipeCategory[]{this.eldrinAltarRecipeCategory});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)MANAWEAVE_PATTERN, (Collection)ManaweavingPatternHelper.getAllPatterns((World)this.minecraft.field_71441_e).stream().map(p -> new ManaweavePatternIngredient(p.func_199560_c())).collect(Collectors.toList()), (IIngredientHelper)new ManaweavingPatternIngredientHelper(), (IIngredientRenderer)manaweaveIngredientRenderer);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = this.minecraft.field_71441_e;
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RecipeInit.RITUAL_TYPE), RecipeCategoryUIDs.RITUAL);
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RecipeInit.ELDRIN_ALTAR_TYPE), RecipeCategoryUIDs.ELDRIN_ALTAR);
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RecipeInit.MANAWEAVING_RECIPE_TYPE), RecipeCategoryUIDs.MANAWEAVING);
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RecipeInit.ARCANE_FURNACE_TYPE), RecipeCategoryUIDs.ARCANE_FURNACE);
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RecipeInit.RUNEFORGING_TYPE), RecipeCategoryUIDs.RUNEFORGING);
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RecipeInit.RUNESCRIBING_TYPE), RecipeCategoryUIDs.RUNESCRIBING);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ContainerSpectralCraftingTable.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.RUNEFORGE.get()), new ResourceLocation[]{RecipeCategoryUIDs.ARCANE_FURNACE, VanillaRecipeCategoryUid.CAMPFIRE, VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.RUNESCRIBING_TABLE.get()), new ResourceLocation[]{RecipeCategoryUIDs.RUNESCRIBING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.RUNIC_ANVIL.get()), new ResourceLocation[]{RecipeCategoryUIDs.RUNEFORGING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.MANAWEAVING_ALTAR.get()), new ResourceLocation[]{RecipeCategoryUIDs.MANAWEAVING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.INSCRIPTION_TABLE.get()), new ResourceLocation[]{RecipeCategoryUIDs.SPELL_PART});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.ELDRIN_ALTAR.get()), new ResourceLocation[]{RecipeCategoryUIDs.ELDRIN_ALTAR});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemInit.WIZARD_CHALK.get()), new ResourceLocation[]{RecipeCategoryUIDs.RITUAL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemInit.PRACTITIONERS_POUCH.get()), new ResourceLocation[]{RecipeCategoryUIDs.RITUAL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockInit.MAGICIANS_WORKBENCH.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
    }
}

