/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei.categories;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.interop.jei.JEIInterop;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.interop.jei.ingredients.ManaweavePatternIngredient;
import com.ma.recipes.eldrin.EldrinAltarRecipe;
import com.ma.tools.MATags;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableInt;

public class EldrinAltarRecipeCategory
implements IRecipeCategory<EldrinAltarRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 144;
    private int ySize = 169;

    public EldrinAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.GUIDEBOOK_RECIPE_BLANK, 0, 0, this.xSize, this.ySize).setTextureSize(144, 169).build();
        this.localizedName = I18n.func_135052_a((String)"gui.mana-and-artifice.jei.eldrin_altar", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockInit.ELDRIN_ALTAR.get()));
    }

    public ResourceLocation getUid() {
        return RecipeCategoryUIDs.ELDRIN_ALTAR;
    }

    public Class<? extends EldrinAltarRecipe> getRecipeClass() {
        return EldrinAltarRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(EldrinAltarRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
        ArrayList<ManaweavePatternIngredient> patternIngredients = new ArrayList<ManaweavePatternIngredient>();
        for (ResourceLocation rLoc : recipe.getRequiredItems()) {
            recipeIngredients.add(Ingredient.func_234819_a_(MATags.smartLookupItem(rLoc).stream().map(item -> {
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (stack.func_77973_b() == Items.field_151068_bn && stack.func_77978_p() == null) {
                    stack = PotionUtils.func_185188_a((ItemStack)stack, (Potion)Potions.field_185230_b);
                }
                return stack;
            })));
        }
        for (ResourceLocation rLoc : recipe.getRequiredPatterns()) {
            patternIngredients.add(new ManaweavePatternIngredient(rLoc));
        }
        ingredients.setInputIngredients(recipeIngredients);
        ingredients.setInputs((IIngredientType)JEIInterop.MANAWEAVE_PATTERN, patternIngredients);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, EldrinAltarRecipe recipe, IIngredients ingredients) {
        int x = 24;
        int y = 25;
        int cX = this.xSize / 2;
        int cY = this.ySize / 2 - 25;
        int reagentIdx = 0;
        float radians = -1.5707964f;
        float radianStep = (float)(Math.PI * 2 / (double)Math.max(recipe.getRequiredItems().length, 1));
        int ingredDist = 30;
        recipeLayout.setShapeless();
        for (List c : ingredients.getInputs(VanillaTypes.ITEM)) {
            int ingredX = cX + (int)Math.round(Math.cos(radians) * (double)ingredDist);
            int ingredY = cY + (int)Math.round(Math.sin(radians) * (double)ingredDist);
            recipeLayout.getItemStacks().init(reagentIdx, true, ingredX - 8, ingredY);
            recipeLayout.getItemStacks().set(reagentIdx, c);
            ++reagentIdx;
            radians += radianStep;
        }
        int xStep = 22;
        x = 8;
        y = 145;
        for (List pattern : ingredients.getInputs((IIngredientType)JEIInterop.MANAWEAVE_PATTERN)) {
            recipeLayout.getIngredientsGroup((IIngredientType)JEIInterop.MANAWEAVE_PATTERN).init(reagentIdx, false, (IIngredientRenderer)JEIInterop.manaweaveIngredientRenderer, x, y, 16, 16, 1, 1);
            recipeLayout.getIngredientsGroup((IIngredientType)JEIInterop.MANAWEAVE_PATTERN).set(reagentIdx, pattern);
            ++reagentIdx;
            x += xStep;
        }
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            recipeLayout.getItemStacks().init(reagentIdx, false, cX - 8, cY);
            recipeLayout.getItemStacks().set(reagentIdx, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public void draw(EldrinAltarRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71466_p != null) {
            int playerTier;
            int tier = recipe.getTier();
            int color = tier <= (playerTier = ((IPlayerProgression)mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier()) ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
            TranslationTextComponent name = new TranslationTextComponent(recipe.func_77571_b().func_77977_a().toString());
            TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
            int stringWidth = mc.field_71466_p.func_238414_a_((ITextProperties)name);
            int textX = this.xSize / 2 - stringWidth / 2;
            int textY = 5;
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(this.xSize / 2 - mc.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), 15.0f, color);
            GuiRenderUtils.renderFactionIcon(matrixStack, recipe.getFactionRequirement(), textX + stringWidth + 3, textY);
            int cX = this.xSize / 2 - 8;
            int affStep = 45;
            int powerCount = recipe.getPowerRequirements().size() - 1;
            int affX = cX - (int)Math.floor((float)powerCount / 2.0f * (float)affStep);
            int affY = this.ySize - 30;
            TranslationTextComponent wellspringPowerReq = new TranslationTextComponent("gui.mana-and-artifice.wellspring-power");
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)wellspringPowerReq, (float)(this.xSize / 2 - mc.field_71466_p.func_238414_a_((ITextProperties)wellspringPowerReq) / 2), (float)(affY - 5), ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
            MutableInt count = new MutableInt(0);
            recipe.getPowerRequirements().forEach((a, v) -> {
                int rX = affX + count.getAndIncrement() * affStep;
                String aText = a.name();
                mc.field_71466_p.func_238421_b_(matrixStack, aText, (float)rX, (float)(affY + 6), ColorHelper.PackedColor.func_233006_a_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]));
                String vText = String.format("%.0f", v);
                mc.field_71466_p.func_238421_b_(matrixStack, vText, (float)(rX + mc.field_71466_p.func_78256_a(vText) / 2), (float)(affY + 16), ColorHelper.PackedColor.func_233006_a_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]));
            });
            RenderSystem.enableBlend();
        }
    }
}

