/*
 * Decompiled with CFR 0.152.
 */
package com.ma.inventory.stack_extension;

import com.ma.inventory.stack_extension.InvalidTypeException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class SlotInfoBase<V> {
    protected final String key;
    protected CompoundNBT tag;

    public SlotInfoBase(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public abstract Class<?> getType();

    public abstract CompoundNBT getTag();

    protected CompoundNBT getBaseTag() {
        if (this.tag == null) {
            this.tag = new CompoundNBT();
            this.tag.func_74778_a("key", this.key);
        }
        return this.tag;
    }

    public String asString() {
        throw new InvalidTypeException(this.getKey() + " cannot be converted into a string.");
    }

    public int asInt() {
        throw new InvalidTypeException(this.getKey() + " cannot be converted into an integer.");
    }

    public float asFloat() {
        throw new InvalidTypeException(this.getKey() + " cannot be converted into a float.");
    }

    public boolean asBoolean() {
        throw new InvalidTypeException(this.getKey() + " cannot be converted into a boolean.");
    }

    public abstract V asObject();

    public static SlotInfoBase<?> fromNBT(CompoundNBT tag) {
        String key = tag.func_74779_i("key");
        INBT value = tag.func_74781_a("value");
        byte id = value.func_74732_a();
        if (id == 8) {
            return new StringDataEntry(key, tag.func_74779_i("value"));
        }
        if (id == 3) {
            return new IntegerDataEntry(key, tag.func_74762_e("value"));
        }
        if (id == 5) {
            return new FloatDataEntry(key, tag.func_74760_g("value"));
        }
        if (id == 1) {
            return new BooleanDataEntry(key, tag.func_74767_n("value"));
        }
        throw new RuntimeException("Invalid NBT tag stored in data entry: " + tag);
    }

    public static class BooleanDataEntry
    extends SlotInfoBase<Boolean> {
        private boolean value;

        public BooleanDataEntry(String key, boolean value) {
            super(key);
            this.value = value;
        }

        @Override
        public Class<?> getType() {
            return Boolean.class;
        }

        @Override
        public CompoundNBT getTag() {
            if (this.tag == null) {
                this.tag = this.getBaseTag();
                this.tag.func_74757_a("value", this.value);
            }
            return this.tag;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }

        @Override
        public Boolean asObject() {
            return this.asBoolean();
        }
    }

    public static class FloatDataEntry
    extends SlotInfoBase<Float> {
        private float value;

        public FloatDataEntry(String key, float value) {
            super(key);
            this.value = value;
        }

        @Override
        public Class<?> getType() {
            return Float.class;
        }

        @Override
        public CompoundNBT getTag() {
            if (this.tag == null) {
                this.tag = this.getBaseTag();
                this.tag.func_74776_a("value", this.value);
            }
            return this.tag;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public Float asObject() {
            return Float.valueOf(this.asFloat());
        }
    }

    public static class IntegerDataEntry
    extends SlotInfoBase<Integer> {
        private int value;

        public IntegerDataEntry(String key, int value) {
            super(key);
            this.value = value;
        }

        @Override
        public Class<?> getType() {
            return Integer.class;
        }

        @Override
        public CompoundNBT getTag() {
            if (this.tag == null) {
                this.tag = this.getBaseTag();
                this.tag.func_74768_a("value", this.value);
            }
            return this.tag;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public Integer asObject() {
            return this.asInt();
        }
    }

    public static class StringDataEntry
    extends SlotInfoBase<String> {
        private String value;

        public StringDataEntry(String key, String value) {
            super(key);
            this.value = value;
        }

        @Override
        public Class<?> getType() {
            return String.class;
        }

        @Override
        public CompoundNBT getTag() {
            if (this.tag == null) {
                this.tag = this.getBaseTag();
                this.tag.func_74778_a("value", this.value);
            }
            return this.tag;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        public String asObject() {
            return this.asString();
        }
    }
}

