/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items;

import com.ma.KeybindInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.IBagItem;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;

public interface IItemWithGui<T extends Item>
extends IBagItem {
    public INamedContainerProvider getProvider(ItemStack var1);

    default public boolean addItemWithGuiTooltip(ItemStack stack) {
        return true;
    }

    default public boolean requiresModifierKey() {
        return true;
    }

    default public boolean openGuiIfModifierPressed(ItemStack stack, PlayerEntity player, World world) {
        MutableBoolean guiOpened = new MutableBoolean(false);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (!this.requiresModifierKey() || m.isModifierPressed()) {
                if (!world.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getProvider(stack));
                }
                guiOpened.setTrue();
            }
        });
        return guiOpened.booleanValue();
    }

    default public void appendHoverText(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.addItemWithGuiTooltip(stack)) {
            return;
        }
        if (this.requiresModifierKey()) {
            String txt = I18n.func_135052_a((String)KeybindInit.inventoryItemOpen.getKey().func_197935_d(), (Object[])new Object[0]);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.item-with-gui.open-with", new Object[]{txt}).func_240699_a_(TextFormatting.AQUA));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.item-with-gui.open-rclick").func_240699_a_(TextFormatting.AQUA));
        }
    }
}

