/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.artifice;

import com.ma.api.capabilities.Faction;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.faction.FactionRaidEntity;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemFactionHorn
extends TieredItem {
    private final Faction faction;

    public ItemFactionHorn(Faction faction) {
        super(new Item.Properties().func_200916_a(MAItemGroups.artifice).func_208103_a(Rarity.EPIC));
        this.faction = faction;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        context.func_195999_j().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getTier() < 5) {
                context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.faction_horn.low_tier"), Util.field_240973_b_);
                return;
            }
            if (p.getAlliedFaction() != this.faction) {
                context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.faction_horn.wrong_faction"), Util.field_240973_b_);
                return;
            }
            context.func_195999_j().func_184811_cZ().func_185145_a((Item)this, 18000);
            world.func_184148_a(null, (double)context.func_195995_a().func_177958_n(), (double)context.func_195995_a().func_177956_o(), (double)context.func_195995_a().func_177952_p(), this.getHornSound(), SoundCategory.PLAYERS, 1.0f, (float)((double)0.9f + (double)0.2f * Math.random()));
            this.spawnAllies(world, context.func_195999_j(), context.func_195995_a().func_177984_a());
        });
        return ActionResultType.SUCCESS;
    }

    private void spawnAllies(World world, PlayerEntity player, BlockPos pos) {
        int strength = 150;
        FactionRaidEntity fre = new FactionRaidEntity(world, null, strength);
        fre.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        fre.setFaction(this.faction);
        fre.setProtective(player);
        world.func_217376_c((Entity)fre);
    }

    private SoundEvent getHornSound() {
        switch (this.faction) {
            case ANCIENT_WIZARDS: {
                return SFX.Event.Faction.FACTION_HORN_COUNCIL;
            }
            case DEMONS: {
                return SFX.Event.Faction.FACTION_HORN_DEMONS;
            }
            case FEY_COURT: {
                return SFX.Event.Faction.FACTION_HORN_FEY;
            }
            case UNDEAD: {
                return SFX.Event.Faction.FACTION_HORN_UNDEAD;
            }
        }
        return SFX.Event.Faction.FACTION_HORN_COUNCIL;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }
}

