/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.manaweaving;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.items.IShowHud;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.gui.containers.providers.NamedCantrips;
import com.ma.items.IItemWithGui;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.sound.ItemInUseLoopingSound;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ItemManaweaverWand
extends TieredItem
implements IShowHud,
IItemWithGui<ItemManaweaverWand> {
    public static final float MANA_COST_PER_TICK = 1.0f;
    private static final String KEY_STORED_ALTAR = "altar_location";
    private static final String KEY_MODEL_DATA = "CustomModelData";

    public ItemManaweaverWand() {
        this(new Item.Properties().func_200917_a(1).func_200916_a(MAItemGroups.items));
    }

    public ItemManaweaverWand(Item.Properties props) {
        super(props);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.MAINHAND;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return;
        }
        if (worldIn.field_72995_K) {
            IPlayerMagic magic = (IPlayerMagic)entityLiving.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            IPlayerProgression progression = (IPlayerProgression)entityLiving.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (magic != null && progression != null) {
                Vector3f[] points = magic.getRememberedPoints();
                Vector3f[] looks = magic.getRememberedLooks();
                if (points.length > 0) {
                    ManaweavingPattern pattern = ManaweavingPattern.match(worldIn, progression.getTier(), points, looks);
                    if (pattern == null) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.not_recognized"), Util.field_240973_b_);
                    } else {
                        if (pattern.getTier() > progression.getTier()) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.low_tier"), Util.field_240973_b_);
                            return;
                        }
                        Vector3d eyePos = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0);
                        Vector3d look = player.func_70040_Z();
                        double avgX = 0.0;
                        double avgZ = 0.0;
                        double minY = Double.MAX_VALUE;
                        for (Vector3f vec : points) {
                            avgX += (double)vec.func_195899_a();
                            avgZ += (double)vec.func_195902_c();
                            if (!((double)vec.func_195900_b() < minY)) continue;
                            minY = vec.func_195900_b();
                        }
                        ClientMessageDispatcher.sendManaweavePatternDrawn(player, pattern.func_199560_c(), new Vector3d(avgX /= (double)points.length, minY - 0.4, avgZ /= (double)points.length), player.func_184600_cs(), this.func_77626_a(stack) - timeLeft);
                    }
                }
            }
        }
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 5);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        MutableBoolean success = new MutableBoolean(true);
        playerIn.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (m.isMagicUnlocked()) {
                if (!this.openGuiIfModifierPressed(itemstack, playerIn, worldIn)) {
                    if (worldIn.field_72995_K) {
                        m.clearRememberedPoints();
                        this.PlayLoopingSound(SFX.Loops.MANAWEAVING, playerIn);
                    }
                    playerIn.func_184598_c(handIn);
                } else {
                    success.setFalse();
                }
            } else {
                if (worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.confusion"), Util.field_240973_b_);
                }
                playerIn.func_184811_cZ().func_185145_a((Item)this, 100);
            }
        });
        if (success.getValue().booleanValue()) {
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195999_j().func_213453_ef()) {
            BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
            if (state.func_177230_c() == BlockInit.MANAWEAVING_ALTAR.get()) {
                if (!context.func_195991_k().func_201670_d()) {
                    stack.func_196082_o().func_218657_a(KEY_STORED_ALTAR, (INBT)NBTUtil.func_186859_a((BlockPos)context.func_195995_a()));
                    stack.func_196082_o().func_74768_a(KEY_MODEL_DATA, 1);
                    context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.position_stored"), Util.field_240973_b_);
                }
                return ActionResultType.FAIL;
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_STORED_ALTAR)) {
                if (!context.func_195991_k().func_201670_d()) {
                    stack.func_196082_o().func_82580_o(KEY_STORED_ALTAR);
                    stack.func_196082_o().func_82580_o(KEY_MODEL_DATA);
                    context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.position_cleared"), Util.field_240973_b_);
                }
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public static BlockPos getStoredBlockPos(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemManaweaverWand && stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_STORED_ALTAR)) {
            return NBTUtil.func_186861_c((CompoundNBT)stack.func_77978_p().func_74775_l(KEY_STORED_ALTAR));
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        EntityManaweave mw;
        if (entity instanceof EntityManaweave && !(mw = (EntityManaweave)entity).isMerging()) {
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic != null) {
                magic.getCastingResource().setAmount(magic.getCastingResource().getAmount() + mw.getManaReturn(player));
                magic.getCastingResource().setNeedsSync();
            }
            player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187528_aR, SoundCategory.PLAYERS, 1.0f, 1.0f);
            mw.remove(false);
            return false;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 999999;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        LazyOptional magicContainer = player.getCapability(PlayerMagicProvider.MAGIC);
        LazyOptional progContainer = player.getCapability(PlayerProgressionProvider.PROGRESSION);
        if (magicContainer.isPresent()) {
            IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
            if (!magic.isMagicUnlocked()) {
                player.func_184597_cx();
                return;
            }
            if (magic.getCastingResource().getAmount() < 1.0f) {
                if (player instanceof PlayerEntity) {
                    ((PlayerEntity)player).func_184811_cZ().func_185145_a((Item)this, 100);
                    if (player.field_70170_p.field_72995_K && player == ManaAndArtifice.instance.proxy.getClientPlayer()) {
                        ((PlayerEntity)player).func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.oom"), Util.field_240973_b_);
                    }
                }
                player.func_184597_cx();
                return;
            }
            if (player.field_70170_p.field_72995_K) {
                Vector3d eyePos = player.func_174824_e(0.0f);
                Vector3d look = player.func_70040_Z();
                Vector3d position = eyePos.func_178787_e(look);
                Vector3d particlePosition = eyePos.func_178787_e(look.func_186678_a(1.5));
                ((IPlayerMagic)magicContainer.orElse(null)).addRememberedPoint(new Vector3f(position), new Vector3f(MathHelper.func_76142_g((float)player.field_70177_z), MathHelper.func_76142_g((float)player.field_70125_A), 0.0f));
                MAParticleType particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_STATIONARY.get())).setMaxAge(40);
                if (progContainer.isPresent()) {
                    switch (((IPlayerProgression)progContainer.resolve().get()).getAlliedFaction()) {
                        case DEMONS: {
                            int[] color = Affinity.FIRE.getColor();
                            particle.setColor(color[0], color[1], color[2]);
                            break;
                        }
                        case FEY_COURT: {
                            if (Math.random() < 0.5) {
                                particle.setColor(37, 135, 58);
                                break;
                            }
                            particle.setColor(213, 112, 225);
                            break;
                        }
                        case UNDEAD: {
                            if (Math.random() < 0.5) {
                                particle.setColor(125, 201, 198);
                                break;
                            }
                            particle.setColor(135, 126, 201);
                            break;
                        }
                    }
                }
                player.field_70170_p.func_195594_a((IParticleData)particle, particlePosition.field_72450_a, particlePosition.field_72448_b, particlePosition.field_72449_c, 0.0, 0.0, 0.0);
            }
            magic.getCastingResource().consume(1.0f);
        }
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID, PlayerEntity player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ItemInUseLoopingSound(soundID, player));
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedCantrips();
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IItemWithGui.super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }
}

