/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.ritual;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.items.ITieredItem;
import com.ma.api.rituals.IRitualReagent;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.api.rituals.RitualEffect;
import com.ma.blocks.BlockInit;
import com.ma.blocks.ritual.ChalkRuneBlock;
import com.ma.blocks.tileentities.ChalkRuneTile;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityRitual;
import com.ma.gui.containers.providers.NamedRitualKit;
import com.ma.inventory.InventoryRitualKit;
import com.ma.inventory.ItemInventoryBase;
import com.ma.items.IRadialMenuItem;
import com.ma.items.ItemBagBase;
import com.ma.items.ItemInit;
import com.ma.items.ItemManaweaveBottle;
import com.ma.items.filters.ItemFilterGroup;
import com.ma.items.ritual.ItemPractitionersPatch;
import com.ma.items.ritual.ItemWizardChalk;
import com.ma.items.ritual.PractitionersPouchPatches;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.rituals.MatchedRitual;
import com.ma.rituals.RitualInit;
import com.ma.rituals.RitualReagent;
import com.ma.rituals.contexts.RitualCheckContext;
import com.ma.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemPractitionersPouch
extends ItemBagBase
implements IRadialMenuItem,
ITieredItem<ItemPractitionersPouch>,
IDyeableArmorItem {
    private static final String TAG_MASTER = "ritual_kit_data";
    private static final String KEY_INDEX = "ritual_kit_index";
    private static final String TAG_RITUAL_RLOC = "ritual_rloc";
    private static final String TAG_RITUAL_POSITION_COUNT = "ritual_position_count";
    private static final String TAG_RITUAL_POSITION_PREFIX = "position_";
    private static final String TAG_RITUAL_REAGENT_COUNT = "ritual_reagent_count";
    private static final String TAG_RITUAL_REAGENT_PREFIX = "reagent_";
    private static final String TAG_PATCHES = "patches";
    public static final int MAX_RITUALS = 8;
    public static final int MAX_PATCHES = 3;
    private int tier;
    public static String NBT_ID = "mana-and-artifice:ritual_bag_data";

    private boolean storeRitual(MatchedRitual match, World world, ItemStack stack) {
        int i;
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(TAG_RITUAL_RLOC, match.getRitual().func_199560_c().toString());
        ArrayList<ItemStack> reagents = new ArrayList<ItemStack>();
        ArrayList<BlockPos> reagent_positions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> rune_positions = new ArrayList<BlockPos>();
        for (RitualBlockPos rbp : match.getPositions()) {
            BlockPos pos = rbp.getBlockPos().func_177973_b((Vector3i)match.getCenter());
            rune_positions.add(pos);
            IRitualReagent reagent = rbp.getReagent();
            if (reagent == null || reagent.isEmpty()) continue;
            ChalkRuneTile tecr = (ChalkRuneTile)world.func_175625_s(match.getCenter().func_177982_a(pos.func_177958_n(), 0, pos.func_177952_p()));
            if (tecr == null) {
                return false;
            }
            ItemStack tecrStack = tecr.func_70301_a(0);
            if (tecrStack.func_190926_b()) {
                if (reagent.isOptional()) continue;
                return false;
            }
            ItemStack tecrCopy = tecrStack.func_77946_l();
            tecrCopy.func_190925_c("ritual_tags").func_74757_a("noConsumeReagent", !reagent.shouldConsumeReagent());
            reagents.add(tecrCopy);
            reagent_positions.add(new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        }
        compound.func_74768_a(TAG_RITUAL_POSITION_COUNT, rune_positions.size());
        for (i = 0; i < rune_positions.size(); ++i) {
            CompoundNBT positionData = new CompoundNBT();
            positionData.func_74768_a("x", ((BlockPos)rune_positions.get(i)).func_177958_n());
            positionData.func_74768_a("y", ((BlockPos)rune_positions.get(i)).func_177956_o());
            positionData.func_74768_a("z", ((BlockPos)rune_positions.get(i)).func_177952_p());
            compound.func_218657_a(TAG_RITUAL_POSITION_PREFIX + i, (INBT)positionData);
        }
        compound.func_74768_a(TAG_RITUAL_REAGENT_COUNT, reagents.size());
        for (i = 0; i < reagents.size(); ++i) {
            CompoundNBT reagentData = new CompoundNBT();
            reagentData.func_74768_a("x", ((BlockPos)reagent_positions.get(i)).func_177958_n());
            reagentData.func_74768_a("y", ((BlockPos)reagent_positions.get(i)).func_177956_o());
            reagentData.func_74768_a("z", ((BlockPos)reagent_positions.get(i)).func_177952_p());
            ((ItemStack)reagents.get(i)).func_77955_b(reagentData);
            compound.func_218657_a(TAG_RITUAL_REAGENT_PREFIX + i, (INBT)reagentData);
        }
        ITextComponent baseDisplayName = new ItemStack((IItemProvider)stack.func_77973_b()).func_200301_q();
        IFormattableTextComponent stc = new StringTextComponent("").func_230529_a_(baseDisplayName).func_240702_b_(": ");
        stc = stc.func_230529_a_((ITextComponent)new TranslationTextComponent(match.getRitual().func_199560_c().toString())).func_240699_a_(TextFormatting.GOLD);
        stack.func_200302_a((ITextComponent)stc);
        CompoundNBT mainCompound = stack.func_196082_o();
        ListNBT list = null;
        list = mainCompound.func_150297_b(TAG_MASTER, 9) ? mainCompound.func_150295_c(TAG_MASTER, 10) : new ListNBT();
        int index = ItemPractitionersPouch.getIndex(stack);
        while (list.size() < 8) {
            list.add((Object)new CompoundNBT());
        }
        list.set(index, (INBT)compound);
        mainCompound.func_218657_a(TAG_MASTER, (INBT)list);
        return true;
    }

    private boolean placeRitual(ItemStack stack, BlockPos center, World world) {
        ArrayList out = new ArrayList();
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        ArrayList<BlockPos> positions = this.getReagentLocations(stack);
        ArrayList<BlockPos> rune_positions = this.getRuneLocations(stack);
        if (reagents.size() != positions.size()) {
            return false;
        }
        for (BlockPos runePos : rune_positions) {
            BlockPos pos = center.func_177982_a(runePos.func_177958_n(), 1, runePos.func_177952_p());
            world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)ChalkRuneBlock.RUNEINDEX, (Comparable)Integer.valueOf((int)Math.floor(Math.random() * (double)(ChalkRuneBlock.RUNEINDEX.func_177700_c().size() - 1))))).func_206870_a((Property)ChalkRuneBlock.METAL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            ChalkRuneTile rune = (ChalkRuneTile)world.func_175625_s(pos);
            if (rune == null) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                out.clear();
                return false;
            }
            int count = 0;
            for (BlockPos reagent_pos : positions) {
                if (reagent_pos.func_177958_n() == runePos.func_177958_n() && reagent_pos.func_177952_p() == runePos.func_177952_p()) {
                    if (reagents.get(count).func_190926_b()) break;
                    boolean ghost = false;
                    ItemStack runeStack = reagents.get(count).func_77946_l();
                    if (runeStack.func_190925_c("ritual_tags").func_74767_n("noConsumeReagent")) {
                        ghost = true;
                    }
                    runeStack.func_196083_e("ritual_tags");
                    rune.func_70299_a(0, runeStack.func_77946_l());
                    rune.setGhostItem(ghost);
                    break;
                }
                ++count;
            }
            rune.setReadOnly(true);
        }
        return true;
    }

    @Nullable
    protected Entity activateRitual(PlayerEntity caster, ItemStack stack, RitualRecipe ritual, BlockPos center, World world) {
        NonNullList<RitualBlockPos> matched = ritual.matchInWorld(center, world);
        if (matched == null) {
            return null;
        }
        IPlayerProgression progression = (IPlayerProgression)caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        float speed = 1.0f - 0.2f * (float)(progression.getTier() - ritual.getTier());
        int numSpeedPatches = this.getPatchLevel(stack, PractitionersPouchPatches.SPEED);
        float speedReduction = 0.3f * (float)Math.min(numSpeedPatches, 3);
        speed -= speed * speedReduction;
        InventoryRitualKit inv = new InventoryRitualKit(stack);
        EntityRitual ritualEntity = new EntityRitual((EntityType<? extends EntityRitual>)((EntityType)EntityInit.RITUAL_ENTITY.get()), world);
        ritualEntity.func_70107_b((float)center.func_177958_n() + 0.5f, center.func_177956_o(), (float)center.func_177952_p() + 0.5f);
        ritualEntity.setRitualBlockLocations(matched);
        ritualEntity.setSpeed(speed);
        ritualEntity.setRitualName(ritual.func_199560_c());
        ritualEntity.setForceConsumeReagents(true);
        ritualEntity.setCasterUUID(caster.func_110124_au());
        if (this.getPatchLevel(stack, PractitionersPouchPatches.WEAVE) > 0) {
            ArrayList<Pair<IItemHandler, Direction>> inventories = new ArrayList<Pair<IItemHandler, Direction>>();
            Pair<IItemHandler, Direction> remoteInv = this.resolveRemoteInventory(stack, caster.field_70170_p);
            if (remoteInv != null) {
                inventories.add(remoteInv);
            }
            if (this.getPatchLevel(stack, PractitionersPouchPatches.RIFT) > 0) {
                caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> inventories.add(new Pair((Object)new InvWrapper((IInventory)m.getRiftInventory()), (Object)Direction.UP)));
            }
            inventories.add(new Pair((Object)inv, (Object)Direction.UP));
            ritualEntity.preConsumePatterns(this.consumePatternItems(inventories, ritual));
        }
        ritualEntity.confirmRitualReagents();
        world.func_217376_c((Entity)ritualEntity);
        return ritualEntity;
    }

    private ArrayList<ItemStack> getReagents(ItemStack stack) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        CompoundNBT nbt = ItemPractitionersPouch.getCurrentCompound(stack, ItemPractitionersPouch.getIndex(stack));
        if (nbt == null || !nbt.func_74764_b(TAG_RITUAL_REAGENT_COUNT)) {
            return out;
        }
        int count = nbt.func_74762_e(TAG_RITUAL_REAGENT_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.func_74764_b(TAG_RITUAL_REAGENT_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundNBT reagent_data = nbt.func_74775_l(TAG_RITUAL_REAGENT_PREFIX + i);
            ItemStack reagent = ItemStack.func_199557_a((CompoundNBT)reagent_data);
            if (reagent == null) {
                out.clear();
                return out;
            }
            out.add(reagent);
        }
        return out;
    }

    private ArrayList<BlockPos> getReagentLocations(ItemStack stack) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        CompoundNBT nbt = ItemPractitionersPouch.getCurrentCompound(stack, ItemPractitionersPouch.getIndex(stack));
        if (nbt == null || !nbt.func_74764_b(TAG_RITUAL_REAGENT_COUNT)) {
            return out;
        }
        int count = nbt.func_74762_e(TAG_RITUAL_REAGENT_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.func_74764_b(TAG_RITUAL_REAGENT_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundNBT reagent_data = nbt.func_74775_l(TAG_RITUAL_REAGENT_PREFIX + i);
            if (!(reagent_data.func_74764_b("x") && reagent_data.func_74764_b("y") && reagent_data.func_74764_b("z"))) {
                out.clear();
                return out;
            }
            out.add(new BlockPos(reagent_data.func_74762_e("x"), reagent_data.func_74762_e("y"), reagent_data.func_74762_e("z")));
        }
        return out;
    }

    private ArrayList<BlockPos> getRuneLocations(ItemStack stack) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        CompoundNBT nbt = ItemPractitionersPouch.getCurrentCompound(stack, ItemPractitionersPouch.getIndex(stack));
        if (nbt == null || !nbt.func_74764_b(TAG_RITUAL_POSITION_COUNT)) {
            return out;
        }
        int count = nbt.func_74762_e(TAG_RITUAL_POSITION_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.func_74764_b(TAG_RITUAL_POSITION_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundNBT position_data = nbt.func_74775_l(TAG_RITUAL_POSITION_PREFIX + i);
            if (!(position_data.func_74764_b("x") && position_data.func_74764_b("y") && position_data.func_74764_b("z"))) {
                out.clear();
                return out;
            }
            out.add(new BlockPos(position_data.func_74762_e("x"), position_data.func_74762_e("y"), position_data.func_74762_e("z")));
        }
        return out;
    }

    private boolean consumeItem(ItemStack stack, InventoryRitualKit inventory, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace, boolean save) {
        boolean removed = false;
        if (!removed && riftInv != null) {
            removed = InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandlerModifiable)new InvWrapper(riftInv));
        }
        if (!removed && remoteInv != null) {
            removed = InventoryUtilities.removeItemFromInventory(stack, true, true, remoteInv, remoteFace);
        }
        if (!removed) {
            removed = InventoryUtilities.removeItemFromInventory(stack, true, true, inventory);
        }
        if (save) {
            inventory.writeItemStack();
        }
        return removed;
    }

    private boolean containsItem(ItemStack stack, InventoryRitualKit inventory, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace) {
        if (riftInv != null && InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandlerModifiable)new InvWrapper(riftInv))) {
            return true;
        }
        if (remoteInv != null && InventoryUtilities.hasStackInInventory(stack, true, true, remoteInv, remoteFace)) {
            return true;
        }
        return InventoryUtilities.hasStackInInventory(stack, true, true, inventory);
    }

    private boolean ritualReagentsPresent(ItemStack stack, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        ArrayList<ItemStack> combinedReagents = new ArrayList<ItemStack>();
        for (ItemStack reagent : reagents) {
            boolean found = false;
            for (ItemStack listStack : combinedReagents) {
                if (listStack.func_77973_b() != reagent.func_77973_b()) continue;
                listStack.func_190920_e(listStack.func_190916_E() + 1);
                found = true;
                break;
            }
            if (found) continue;
            combinedReagents.add(reagent.func_77946_l());
        }
        combinedReagents.add(new ItemStack((IItemProvider)ItemInit.PURIFIED_VINTEUM_DUST.get()));
        for (ItemStack reagent : combinedReagents) {
            int totalCount = 0;
            if (riftInv != null) {
                totalCount += riftInv.func_213901_a(reagent.func_77973_b());
            }
            if (remoteInv != null) {
                totalCount += InventoryUtilities.countItem(reagent.func_77973_b(), remoteInv, remoteFace);
            }
            if ((totalCount += inventory.countItem(reagent.func_77973_b())) >= reagent.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    private boolean chalkPresent(ItemStack stack, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace, int requiredUses) {
        ItemStack invStack;
        int i;
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        int foundUses = 0;
        if (riftInv != null) {
            for (i = 0; i < riftInv.func_70302_i_(); ++i) {
                invStack = riftInv.func_70301_a(i);
                if (invStack.func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
                foundUses += invStack.func_77958_k() - invStack.func_77952_i();
            }
        }
        if (remoteInv != null) {
            for (i = 0; i < remoteInv.getSlots(); ++i) {
                invStack = remoteInv.extractItem(i, 1, true);
                if (invStack.func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
                foundUses += invStack.func_77958_k() - invStack.func_77952_i();
            }
        }
        for (i = 0; i < inventory.getSlots(); ++i) {
            invStack = inventory.getStackInSlot(i);
            if (invStack.func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
            foundUses += invStack.func_77958_k() - invStack.func_77952_i();
        }
        return foundUses >= requiredUses;
    }

    private boolean consumeChalk(ItemStack stack, IItemHandlerModifiable riftInv, IItemHandler remoteInv, Direction remoteFace, int amount) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        int remaining = amount;
        if (remaining > 0 && riftInv != null) {
            remaining = this.consumeChalkFromInventory(riftInv, remaining);
        }
        if (remaining > 0 && remoteInv != null) {
            remaining = this.consumeChalkFromInventory(remoteInv, remoteFace, remaining);
        }
        if (remaining > 0 && inventory != null) {
            remaining = this.consumeChalkFromInventory(inventory, remaining);
            inventory.writeItemStack();
        }
        return remaining == 0;
    }

    private List<ResourceLocation> consumePatternItems(List<Pair<IItemHandler, Direction>> inventories, RitualRecipe recipe) {
        String[] requiredPatterns = recipe.getManaweavePatterns();
        ArrayList<ResourceLocation> consumedPatterns = new ArrayList<ResourceLocation>();
        block0: for (String pattern : requiredPatterns) {
            ResourceLocation rLoc = new ResourceLocation(pattern);
            for (int i = 0; i < inventories.size(); ++i) {
                IItemHandler inventory = (IItemHandler)inventories.get(i).getFirst();
                Direction face = (Direction)inventories.get(i).getSecond();
                if (!this.consumePatternJar(inventory, rLoc)) continue;
                consumedPatterns.add(rLoc);
                continue block0;
            }
        }
        return consumedPatterns;
    }

    public boolean consumePatternJar(IItemHandler inventory, ResourceLocation rLoc) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ManaweavingPattern pattern;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemManaweaveBottle.hasPattern(stack) || !(pattern = ItemManaweaveBottle.getPattern(stack)).func_199560_c().equals((Object)rLoc) || inventory.extractItem(i, 1, false).func_190926_b()) continue;
            if (inventory instanceof ItemInventoryBase) {
                ((ItemInventoryBase)inventory).writeItemStack();
            }
            return true;
        }
        return false;
    }

    private int consumeChalkFromInventory(IItemHandlerModifiable inventory, int amount) {
        int remaining = amount;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack.func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
            int uses = inventoryStack.func_77958_k() - inventoryStack.func_77952_i();
            if (uses > remaining) {
                inventoryStack.func_196085_b(inventoryStack.func_77952_i() + remaining);
                inventory.setStackInSlot(i, inventoryStack);
                return 0;
            }
            if (uses == remaining) {
                inventory.setStackInSlot(i, ItemStack.field_190927_a);
                return 0;
            }
            remaining -= uses;
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return remaining;
    }

    private int consumeChalkFromInventory(IItemHandler handler, Direction remoteFace, int amount) {
        int remaining = amount;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inventoryStack = handler.extractItem(i, 1, true);
            if (inventoryStack.func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
            int uses = inventoryStack.func_77958_k() - inventoryStack.func_77952_i();
            if (uses > remaining) {
                inventoryStack = handler.extractItem(i, 1, false);
                inventoryStack.func_196085_b(inventoryStack.func_77952_i() + remaining);
                inventoryStack = handler.insertItem(i, inventoryStack, false);
                if (!inventoryStack.func_190926_b()) break;
                return 0;
            }
            if (uses == remaining) {
                handler.extractItem(i, 1, false);
                return 0;
            }
            remaining -= uses;
            handler.extractItem(i, 1, false);
        }
        return remaining;
    }

    private boolean consumeRitualReagents(RitualRecipe recipe, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace, ItemStack stack) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        RitualReagent[] allreagents = recipe.AllReagents();
        int count = 0;
        for (ItemStack reagent : reagents) {
            if (!allreagents[count].shouldConsumeReagent()) continue;
            ItemStack searchCopy = reagent.func_77946_l();
            if (searchCopy.func_77942_o()) {
                searchCopy.func_77978_p().func_82580_o("ritual_tags");
                if (searchCopy.func_77978_p().isEmpty()) {
                    searchCopy.func_77982_d(null);
                }
            }
            this.consumeItem(searchCopy, inventory, riftInv, remoteInv, remoteFace, false);
        }
        this.consumeItem(new ItemStack((IItemProvider)ItemInit.PURIFIED_VINTEUM_DUST.get()), inventory, riftInv, remoteInv, remoteFace, false);
        inventory.writeItemStack();
        return true;
    }

    public boolean hasRoomForItem(ItemStack bag, ItemStack stack) {
        InventoryRitualKit inv = new InventoryRitualKit(bag);
        return inv.canMergeItem(stack);
    }

    public ItemStack insertItem(ItemStack bag, ItemStack stack) {
        InventoryRitualKit inv = new InventoryRitualKit(bag);
        ItemStack resultantStack = inv.addItem(stack);
        inv.writeItemStack();
        return resultantStack;
    }

    public boolean shouldVoidItem(ItemStack bag, ItemStack stack) {
        InventoryRitualKit inv = new InventoryRitualKit(bag);
        return inv.shouldVoidItem(stack);
    }

    private CompoundNBT getPatchTag(ItemStack stack) {
        return stack.func_190925_c(TAG_PATCHES);
    }

    public boolean isPatchValid(ItemStack stack, PractitionersPouchPatches patch, int level) {
        int existingLevel = this.getPatchLevel(stack, patch);
        if (existingLevel >= level) {
            return false;
        }
        if (existingLevel < level) {
            return true;
        }
        return this.getAppliedPatches(stack).length < 3;
    }

    public boolean addPatch(ItemStack stack, PractitionersPouchPatches patch, int level) {
        if (this.isPatchValid(stack, patch, level)) {
            this.getPatchTag(stack).func_74768_a(patch.name(), Math.min(level, patch.getLevels()));
            return true;
        }
        return false;
    }

    public int getPatchLevel(ItemStack stack, PractitionersPouchPatches patch) {
        CompoundNBT patchTag = this.getPatchTag(stack);
        if (patchTag.func_74764_b(patch.name())) {
            return patchTag.func_74762_e(patch.name());
        }
        return 0;
    }

    public PractitionersPouchPatches[] getAppliedPatches(ItemStack stack) {
        CompoundNBT patchTag = this.getPatchTag(stack);
        List<PractitionersPouchPatches> patchList = patchTag.func_150296_c().stream().map(s -> {
            try {
                return PractitionersPouchPatches.valueOf(s);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(p -> p != null).collect(Collectors.toList());
        return patchList.toArray(new PractitionersPouchPatches[0]);
    }

    public int countAppliedPatchesForLimit(ItemStack stack) {
        CompoundNBT patchTag = this.getPatchTag(stack);
        List patchList = patchTag.func_150296_c().stream().map(s -> {
            try {
                return PractitionersPouchPatches.valueOf(s);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(p -> p != null && p != PractitionersPouchPatches.SPEED).collect(Collectors.toList());
        return patchList.size();
    }

    @Nullable
    public Pair<IItemHandler, Direction> resolveRemoteInventory(ItemStack stack, World world) {
        InventoryRitualKit inv = new InventoryRitualKit(stack);
        ItemStack markStack = inv.getStackInSlot(21);
        if (markStack.func_190926_b() || !(markStack.func_77973_b() instanceof ItemRuneMarking)) {
            return null;
        }
        BlockPos pos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(markStack);
        Direction face = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(markStack);
        if (pos == null) {
            return null;
        }
        if (!world.func_195588_v(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        LazyOptional handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        if (!handler.isPresent()) {
            return null;
        }
        return new Pair(handler.resolve().get(), (Object)face);
    }

    @Nullable
    private static RitualRecipe getRitual(World world, ItemStack stack) {
        ResourceLocation rLoc = new ResourceLocation(ItemPractitionersPouch.getRitualRLoc(stack, ItemPractitionersPouch.getIndex(stack)));
        return RitualRecipe.find(world, rLoc);
    }

    public static String getRitualRLoc(ItemStack stack, int index) {
        CompoundNBT compound = ItemPractitionersPouch.getCurrentCompound(stack, index);
        if (compound == null || !compound.func_74764_b(TAG_RITUAL_RLOC)) {
            return "";
        }
        return compound.func_74779_i(TAG_RITUAL_RLOC);
    }

    @Nullable
    private static CompoundNBT getCurrentCompound(ItemStack stack, int index) {
        ListNBT list;
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(TAG_MASTER)) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag.func_150297_b(TAG_MASTER, 10)) {
            return tag.func_74775_l(TAG_MASTER);
        }
        if (tag.func_150297_b(TAG_MASTER, 9) && index < (list = (ListNBT)tag.func_74781_a(TAG_MASTER)).size()) {
            return list.func_150305_b(index);
        }
        return null;
    }

    public static void setIndex(ItemStack stack, int index) {
        stack.func_196082_o().func_74768_a(KEY_INDEX, index);
        String translationKey = ItemPractitionersPouch.getRitualRLoc(stack, ItemPractitionersPouch.getIndex(stack));
        if (translationKey != "") {
            ITextComponent baseDisplayName = new ItemStack((IItemProvider)stack.func_77973_b()).func_200301_q();
            IFormattableTextComponent stc = new StringTextComponent("").func_230529_a_(baseDisplayName).func_240702_b_(": ");
            stc = stc.func_230529_a_((ITextComponent)new TranslationTextComponent(translationKey)).func_240699_a_(TextFormatting.GOLD);
            stack.func_200302_a((ITextComponent)stc);
        } else {
            stack.func_135074_t();
        }
    }

    public static int getIndex(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(KEY_INDEX);
        }
        return 0;
    }

    public static boolean consumeItem(ItemStack bagStack, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace, ItemStack consumeStack) {
        InventoryRitualKit inventory = new InventoryRitualKit(bagStack);
        return ((ItemPractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).consumeItem(consumeStack, inventory, riftInv, remoteInv, remoteFace, true);
    }

    public static boolean containsItem(ItemStack bagStack, IInventory riftInv, IItemHandler remoteInv, Direction remoteFace, ItemStack searchStack) {
        return ((ItemPractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).containsItem(searchStack, new InventoryRitualKit(bagStack), riftInv, remoteInv, remoteFace);
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K && hand == Hand.MAIN_HAND) {
            this.openGuiIfModifierPressed(player.func_184586_b(hand), player, world);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ITextComponent cantStartReason;
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        if (!world.field_72995_K && context.func_221531_n() == Hand.MAIN_HAND && this.openGuiIfModifierPressed(context.func_195996_i(), context.func_195999_j(), context.func_195991_k())) {
            return ActionResultType.SUCCESS;
        }
        IPlayerMagic magic = (IPlayerMagic)context.func_195999_j().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        IPlayerProgression progression = (IPlayerProgression)context.func_195999_j().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == BlockInit.CHALK_RUNE.get() && context.func_195999_j().func_213453_ef()) {
            MatchedRitual ritualMatch = RitualRecipe.matchAnyInWorld(pos, world);
            if (ritualMatch != null) {
                if (!ritualMatch.getRitual().getIsKittable()) {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.practitioners_pouch.not_kittable", (Object[])new Object[0])), Util.field_240973_b_);
                } else if (this.storeRitual(ritualMatch, world, stack)) {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.practitioners_pouch.stored", (Object[])new Object[0])), Util.field_240973_b_);
                } else {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.practitioners_pouch.store_failed", (Object[])new Object[0])), Util.field_240973_b_);
                }
            } else {
                context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.practitioners_pouch.not_found", (Object[])new Object[0])), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        RitualRecipe ritual = ItemPractitionersPouch.getRitual(context.func_195991_k(), stack);
        if (ritual == null) {
            return ActionResultType.SUCCESS;
        }
        if (ritual.getTier() > progression.getTier()) {
            context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:ritual-start-tier-fail"), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        int bound = ritual.getLowerBound();
        for (int i = -bound; i <= bound; ++i) {
            for (int j = -bound; j <= bound; ++j) {
                if (!Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177982_a(i, 0, j))) {
                    return ActionResultType.PASS;
                }
                if (world.func_175623_d(pos.func_177982_a(i, 1, j))) continue;
                return ActionResultType.PASS;
            }
        }
        Inventory riftInv = null;
        Pair<IItemHandler, Direction> remoteInv = new Pair<IItemHandler, Direction>(null, (Object)Direction.UP);
        if (this.getPatchLevel(stack, PractitionersPouchPatches.RIFT) > 0) {
            riftInv = magic.getRiftInventory();
        }
        if (this.getPatchLevel(stack, PractitionersPouchPatches.CONVEYANCE) > 0) {
            remoteInv = this.resolveRemoteInventory(stack, world);
        }
        if (!this.ritualReagentsPresent(stack, (IInventory)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond()) || !this.chalkPresent(stack, (IInventory)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), ritual.countRunes())) {
            context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.practitioners_pouch.not_enough_items", (Object[])new Object[0])), Util.field_240973_b_);
            return ActionResultType.PASS;
        }
        RitualEffect matchedEffect = RitualInit.RITUAL_EFFECTS.getValues().stream().filter(r -> r.matchRitual(ritual.func_199560_c())).findFirst().orElse(null);
        if (matchedEffect == null) {
            context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:ritual-start-failed"), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        if ((!context.func_195999_j().func_184812_l_() || matchedEffect.applyStartCheckInCreative()) && (cantStartReason = matchedEffect.canRitualStart(new RitualCheckContext(context.func_195999_j(), (ServerWorld)world, ritual, pos.func_177984_a(), null))) != null) {
            context.func_195999_j().func_145747_a(cantStartReason, Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        if (!this.consumeRitualReagents(ritual, (IInventory)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), stack) || !this.consumeChalk(stack, (IItemHandlerModifiable)(riftInv != null ? new InvWrapper((IInventory)riftInv) : null), (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), ritual.countRunes())) {
            ManaAndArtifice.LOGGER.error("Failed to consume ritual reagents from the ritual bag.  This is likely due to a conveyance rune marked on an inventory it can't insert AND extract from.");
            return ActionResultType.PASS;
        }
        if (this.placeRitual(stack, pos, world)) {
            this.activateRitual(context.func_195999_j(), stack, ritual, pos.func_177984_a(), world);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        RitualRecipe ritual = ItemPractitionersPouch.getRitual(worldIn, stack);
        if (Screen.func_231173_s_()) {
            String patchString = I18n.func_135052_a((String)"item.mana-and-artifice.patch.prompt", (Object[])new Object[0]);
            PractitionersPouchPatches[] patches = this.getAppliedPatches(stack);
            if (patches.length > 0) {
                for (int i = 0; i < patches.length; ++i) {
                    ItemStack patchStack = ItemPractitionersPatch.getItemFor(patches[i], this.getPatchLevel(stack, patches[i]));
                    patchString = patchString + I18n.func_135052_a((String)patchStack.func_77977_a(), (Object[])new Object[0]) + ", ";
                }
                patchString = patchString.substring(0, patchString.length() - 2);
                tooltip.add((ITextComponent)new StringTextComponent(patchString).func_240699_a_(TextFormatting.YELLOW));
            }
            if (ritual == null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.practitioners_pouch.no_ritual_stored"));
            } else {
                TextFormatting notFoundColor;
                boolean hasRemoteInvPatch;
                ArrayList<ItemStack> reagents = this.getReagents(stack);
                InventoryRitualKit irk = new InventoryRitualKit(stack);
                ArrayList<ItemStack> combinedReagents = new ArrayList<ItemStack>();
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.practitioners_pouch.reagents"));
                for (ItemStack reagent : reagents) {
                    boolean found = false;
                    for (ItemStack listStack : combinedReagents) {
                        if (listStack.func_77973_b() != reagent.func_77973_b()) continue;
                        listStack.func_190920_e(listStack.func_190916_E() + 1);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    combinedReagents.add(reagent.func_77946_l());
                }
                combinedReagents.add(new ItemStack((IItemProvider)ItemInit.PURIFIED_VINTEUM_DUST.get()));
                boolean hasRiftPatch = this.getPatchLevel(stack, PractitionersPouchPatches.RIFT) > 0;
                boolean bl = hasRemoteInvPatch = this.getPatchLevel(stack, PractitionersPouchPatches.CONVEYANCE) > 0;
                TextFormatting textFormatting = hasRiftPatch && hasRemoteInvPatch ? TextFormatting.LIGHT_PURPLE : (hasRiftPatch && !hasRemoteInvPatch ? TextFormatting.DARK_PURPLE : (notFoundColor = !hasRiftPatch && hasRemoteInvPatch ? TextFormatting.YELLOW : TextFormatting.RED));
                if (this.chalkPresent(stack, null, null, Direction.UP, ritual.countRunes())) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(((ItemWizardChalk)ItemInit.WIZARD_CHALK.get()).func_77658_a()).func_240699_a_(TextFormatting.GREEN));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent(((ItemWizardChalk)ItemInit.WIZARD_CHALK.get()).func_77658_a()).func_240699_a_(notFoundColor));
                }
                for (ItemStack listStack : combinedReagents) {
                    if (listStack.func_190926_b()) continue;
                    if (irk.countItem(listStack.func_77973_b()) >= listStack.func_190916_E()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent(listStack.func_77973_b().func_77658_a()).func_240699_a_(TextFormatting.GREEN));
                        continue;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent(listStack.func_77973_b().func_77658_a()).func_240699_a_(notFoundColor));
                }
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.shift_prompt").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
        IRadialMenuItem.super.appendHoverText(stack, worldIn, tooltip, flagIn);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ItemFilterGroup filterGroup() {
        return ItemFilterGroup.ALL_ITEMS;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedRitualKit(stack);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b(NBT_ID)) {
            stack.func_77982_d(nbt);
        }
        return null;
    }

    @Override
    public int getCachedtier() {
        return this.tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this.tier = tier;
    }
}

