/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.runes;

import com.ma.advancements.CustomAdvancementTriggers;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.entities.utility.EntityThrownRunescribingPattern;
import com.ma.items.ItemInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class ItemRunePattern
extends TieredItem {
    private static final String NBT_KEY_HMUTEX = "hmutex";
    private static final String NBT_KEY_VMUTEX = "vmutex";
    private static final String NBT_KEY_USES = "uses";
    private static final int max_uses = 4;

    public ItemRunePattern() {
        super(new Item.Properties().func_200916_a(MAItemGroups.runes));
    }

    public ItemRunePattern(Item.Properties properties) {
        super(properties);
    }

    public long getHMutex(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        CompoundNBT tag = stack.func_196082_o();
        return tag.func_74763_f(NBT_KEY_HMUTEX);
    }

    public void setHMutex(ItemStack stack, long hMutex) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74772_a(NBT_KEY_HMUTEX, hMutex);
    }

    public long getVMutex(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        CompoundNBT tag = stack.func_196082_o();
        return tag.func_74763_f(NBT_KEY_VMUTEX);
    }

    public void setVMutex(ItemStack stack, long vMutex) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74772_a(NBT_KEY_VMUTEX, vMutex);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_KEY_USES)) {
            return (float)stack.func_77978_p().func_74762_e(NBT_KEY_USES) / 4.0f;
        }
        return 0.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (itemstack.func_77973_b() != ItemInit.RUNE_PATTERN.get() || this.getHMutex(itemstack) == 0L && this.getVMutex(itemstack) == 0L) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EntityThrownRunescribingPattern dangit = new EntityThrownRunescribingPattern(worldIn, (LivingEntity)playerIn);
            dangit.func_213884_b(itemstack);
            dangit.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_217376_c((Entity)dangit);
            CustomAdvancementTriggers.THROWN_RUNESCRIBE_PATTERN.trigger((ServerPlayerEntity)playerIn);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResult.func_233538_a_((Object)itemstack, (boolean)worldIn.func_201670_d());
    }

    public static boolean incrementDamage(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        int uses = nbt.func_74762_e(NBT_KEY_USES) + 1;
        nbt.func_74768_a(NBT_KEY_USES, uses);
        return uses == 4;
    }
}

