/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.config.GeneralModConfig;
import com.ma.items.ItemInit;
import com.ma.tools.math.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemCrystalPhylactery
extends TieredItem
implements IForgeItem {
    private static final String NBT_ENTITYTYPE = "mana-and-artifice:summon_entity_type";
    private static final String NBT_AMOUNT = "mana-and-artifice:summon_fill_pct";
    private static final float CAPACITY = ((Integer)GeneralModConfig.MA_PHYLACTERY_KILLS.get()).intValue();

    public ItemCrystalPhylactery() {
        super(new Item.Properties().func_200916_a(MAItemGroups.thaumaturgy));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EntityType<? extends MobEntity> type = ItemCrystalPhylactery.getEntityType(stack);
        if (type != null) {
            String entityType = I18n.func_135052_a((String)type.func_210760_d(), (Object[])new Object[0]);
            float amount = ItemCrystalPhylactery.getFillAmount(stack);
            if (amount < CAPACITY) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_phylactery.tooltip", new Object[]{entityType, (int)amount, (int)CAPACITY}).func_240699_a_(TextFormatting.GOLD));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_phylactery.tooltip", new Object[]{entityType, (int)amount, (int)CAPACITY}).func_240699_a_(TextFormatting.DARK_PURPLE));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_phylactery.empty").func_240699_a_(TextFormatting.AQUA));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        float amount = ItemCrystalPhylactery.getFillAmount(stack);
        if (amount < CAPACITY) {
            return 0xFFAA00;
        }
        return 0xAA00AA;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        float amount = ItemCrystalPhylactery.getFillAmount(stack);
        if (amount > 0.0f && amount < 5.0f) {
            amount = 4.0f;
        }
        return 1.0f - amount / CAPACITY;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public static boolean isFilled(ItemStack stack) {
        return ItemCrystalPhylactery.getFillAmount(stack) == CAPACITY;
    }

    public static void addToPhylactery(IInventory inventory, EntityType<? extends MobEntity> type, float amount, World world) {
        int matching_slot = -1;
        int empty_slot = -1;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() != ItemInit.CRYSTAL_PHYLACTERY.get()) continue;
            EntityType<? extends MobEntity> containedType = ItemCrystalPhylactery.getEntityType(stack);
            if (containedType == type) {
                float containedAmount = ItemCrystalPhylactery.getFillAmount(stack);
                if (!(containedAmount < CAPACITY)) continue;
                matching_slot = i;
                continue;
            }
            if (containedType != null) continue;
            empty_slot = i;
        }
        if (matching_slot > -1) {
            ItemStack matching = inventory.func_70301_a(matching_slot);
            float existing = ItemCrystalPhylactery.getFillAmount(matching);
            existing = MathUtils.clamp(existing + amount, 0.0f, CAPACITY);
            ItemCrystalPhylactery.setFillAmount(matching, existing);
        } else if (empty_slot > -1) {
            ItemStack empty = inventory.func_70301_a(empty_slot);
            if (inventory instanceof PlayerInventory) {
                EntityType<? extends MobEntity> containedType;
                empty = ItemStack.field_190927_a;
                PlayerInventory inv = (PlayerInventory)inventory;
                ItemStack mainHand = inv.field_70458_d.func_184614_ca();
                ItemStack offHand = inv.field_70458_d.func_184592_cb();
                if (offHand.func_77973_b() == ItemInit.CRYSTAL_PHYLACTERY.get()) {
                    EntityType<? extends MobEntity> containedType2 = ItemCrystalPhylactery.getEntityType(offHand);
                    if (containedType2 == null) {
                        empty = offHand;
                    }
                } else if (mainHand.func_77973_b() == ItemInit.CRYSTAL_PHYLACTERY.get() && (containedType = ItemCrystalPhylactery.getEntityType(mainHand)) == null) {
                    empty = mainHand;
                }
            }
            if (!empty.func_190926_b()) {
                ItemCrystalPhylactery.setEntityType(empty, type, world);
                ItemCrystalPhylactery.setFillAmount(empty, amount);
            }
        }
    }

    public static void setFillAmount(ItemStack stack, float amount) {
        if (stack.func_77973_b() != ItemInit.CRYSTAL_PHYLACTERY.get() || ItemCrystalPhylactery.getEntityType(stack) == null) {
            return;
        }
        stack.func_77978_p().func_74776_a(NBT_AMOUNT, amount);
    }

    public static float getFillAmount(ItemStack stack) {
        if (stack.func_77973_b() != ItemInit.CRYSTAL_PHYLACTERY.get() || ItemCrystalPhylactery.getEntityType(stack) == null) {
            return 0.0f;
        }
        return MathUtils.clamp(stack.func_77978_p().func_74760_g(NBT_AMOUNT), 0.0f, CAPACITY);
    }

    @Nullable
    public static EntityType<? extends MobEntity> getEntityType(ItemStack stack) {
        if (stack.func_77973_b() != ItemInit.CRYSTAL_PHYLACTERY.get() || stack.func_77952_i() > 0 || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_ENTITYTYPE)) {
            return null;
        }
        String type = stack.func_77978_p().func_74779_i(NBT_ENTITYTYPE);
        ResourceLocation rLoc = new ResourceLocation(type);
        try {
            EntityType resolvedType = (EntityType)ForgeRegistries.ENTITIES.getValue(rLoc);
            return resolvedType;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static void setEntityType(ItemStack stack, EntityType<? extends MobEntity> type, World world) {
        if (stack.func_77973_b() != ItemInit.CRYSTAL_PHYLACTERY.get() || ItemCrystalPhylactery.getEntityType(stack) != null) {
            return;
        }
        MobEntity inst = (MobEntity)type.func_200721_a(world);
        if (!((Boolean)GeneralModConfig.MA_PHYLACTERY_BOSSES.get()).booleanValue() && !inst.func_184222_aU()) {
            return;
        }
        stack.func_196082_o().func_74778_a(NBT_ENTITYTYPE, type.getRegistryName().toString());
    }
}

