/*
 * Decompiled with CFR 0.152.
 */
package com.ma.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PlayerFactionCheck
implements ILootCondition {
    public static final LootConditionType PLAYER_FACTION = new LootConditionType((ILootSerializer)new Serializer());
    private final Faction faction;

    private PlayerFactionCheck(Faction faction) {
        this.faction = faction;
    }

    public LootConditionType func_230419_b_() {
        return PLAYER_FACTION;
    }

    public boolean test(LootContext context) {
        PlayerEntity lastPlayer = (PlayerEntity)context.func_216031_c(LootParameters.field_216282_b);
        if (lastPlayer == null || this.faction == Faction.NONE) {
            return false;
        }
        MutableBoolean factionMatch = new MutableBoolean(false);
        lastPlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> factionMatch.setValue(this.faction == p.getAlliedFaction()));
        return factionMatch.booleanValue();
    }

    public static class Serializer
    implements ILootSerializer<PlayerFactionCheck> {
        public void serialize(JsonObject json, PlayerFactionCheck check, JsonSerializationContext context) {
            json.addProperty("faction", check.faction.toString());
        }

        public PlayerFactionCheck deserialize(JsonObject p_230423_1_, JsonDeserializationContext p_230423_2_) {
            try {
                Faction faction = Faction.valueOf(JSONUtils.func_151200_h((JsonObject)p_230423_1_, (String)"faction"));
                return new PlayerFactionCheck(faction);
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.catching((Throwable)ex);
                return new PlayerFactionCheck(Faction.NONE);
            }
        }
    }
}

