/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class EnderDiscPatternSetMessage
extends BaseMessage {
    private ArrayList<ResourceLocation> patterns;
    private int patternIndex;
    private String name;

    public EnderDiscPatternSetMessage(ArrayList<ResourceLocation> patterns, int patternIndex, String name) {
        this.patterns = patterns;
        this.patternIndex = patternIndex;
        this.name = name;
        this.messageIsValid = true;
    }

    public EnderDiscPatternSetMessage() {
        this.messageIsValid = false;
    }

    public ArrayList<ResourceLocation> getPatterns() {
        return this.patterns;
    }

    public int getIndex() {
        return this.patternIndex;
    }

    public String getName() {
        return this.name;
    }

    public static EnderDiscPatternSetMessage decode(PacketBuffer buf) {
        EnderDiscPatternSetMessage msg = new EnderDiscPatternSetMessage();
        try {
            msg.patternIndex = buf.readInt();
            msg.name = buf.func_150789_c(Short.MAX_VALUE);
            int count = buf.readInt();
            msg.patterns = new ArrayList();
            for (int i = 0; i < count; ++i) {
                msg.patterns.add(buf.func_192575_l());
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading EnderDiscPatternSetMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(EnderDiscPatternSetMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.getIndex());
        buf.func_180714_a(msg.getName());
        buf.writeInt(msg.getPatterns().size());
        for (ResourceLocation rLoc : msg.getPatterns()) {
            buf.func_192572_a(rLoc);
        }
    }
}

