/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class MultiblockSyncRequestMessage
extends BaseMessage {
    private int entityID;
    private ResourceLocation recipeID;

    private MultiblockSyncRequestMessage() {
        this.messageIsValid = false;
    }

    public MultiblockSyncRequestMessage(int entityID, ResourceLocation recipe) {
        this();
        this.entityID = entityID;
        this.recipeID = recipe;
        this.messageIsValid = true;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public ResourceLocation getRecipe() {
        return this.recipeID;
    }

    public static MultiblockSyncRequestMessage decode(PacketBuffer buf) {
        MultiblockSyncRequestMessage msg = new MultiblockSyncRequestMessage();
        try {
            msg.entityID = buf.readInt();
            msg.recipeID = buf.func_192575_l();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MultiblockSyncRequestMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(MultiblockSyncRequestMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.getEntityID());
        buf.func_192572_a(msg.getRecipe());
    }
}

