/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;

public class SpellAdjustmentsMessage
extends BaseMessage {
    private CompoundNBT spellValues;
    private Hand hand;

    public SpellAdjustmentsMessage(CompoundNBT spellValues, Hand hand) {
        this.spellValues = spellValues;
        this.hand = hand;
        this.messageIsValid = true;
    }

    public SpellAdjustmentsMessage() {
        this.messageIsValid = false;
    }

    public CompoundNBT getData() {
        return this.spellValues;
    }

    public Hand getHand() {
        return this.hand;
    }

    public static SpellAdjustmentsMessage decode(PacketBuffer buf) {
        SpellAdjustmentsMessage msg = new SpellAdjustmentsMessage();
        try {
            msg.spellValues = buf.func_150793_b();
            msg.hand = Hand.values()[buf.readInt()];
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading SpellAdjustmentsMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SpellAdjustmentsMessage msg, PacketBuffer buf) {
        buf.func_150786_a(msg.getData());
        buf.writeInt(msg.hand.ordinal());
    }
}

