/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles.types.movers;

import com.ma.api.particles.IParticleMoveType;
import com.ma.particles.base.MAParticleBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public class ParticleVelocityMover
implements IParticleMoveType {
    private Vector3d velocity;
    private boolean decay;

    public ParticleVelocityMover() {
        this.velocity = new Vector3d(0.0, 0.0, 0.0);
        this.decay = false;
    }

    public ParticleVelocityMover(double dx, double dy, double dz, boolean decay) {
        this.velocity = new Vector3d(dx, dy, dz);
        this.decay = decay;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.writeDouble(this.velocity.field_72450_a);
        buffer.writeDouble(this.velocity.field_72448_b);
        buffer.writeDouble(this.velocity.field_72449_c);
        buffer.writeBoolean(this.decay);
    }

    @Override
    public String serialize() {
        return "VelocityMover:" + this.velocity.field_72450_a + ":" + this.velocity.field_72448_b + ":" + this.velocity.field_72449_c + ":" + this.decay;
    }

    @Override
    public IParticleMoveType deserialize(PacketBuffer buffer) {
        this.velocity = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.decay = buffer.readBoolean();
        return this;
    }

    @Override
    public void deserialize(String string) {
        if (string.startsWith("VelocityMover")) {
            String[] parts = string.split(":");
            this.velocity = new Vector3d(Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
            this.decay = Boolean.parseBoolean(parts[4]);
        }
    }

    @Override
    public void configureParticle(MAParticleBase particle) {
        particle.setMoveVelocity(this.velocity.field_72450_a, this.velocity.field_72448_b, this.velocity.field_72449_c, this.decay);
    }

    @Override
    public int getId() {
        return 0;
    }
}

