/*
 * Decompiled with CFR 0.152.
 */
package com.ma.progression;

import com.ma.Registries;
import com.ma.api.progression.ProgressionCondition;
import com.ma.config.GeneralModConfig;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public class ProgressionHelper {
    private static double PCT_ALLOWED = -1.0;

    public static double getPctAllowed() {
        if (PCT_ALLOWED < 0.0) {
            PCT_ALLOWED = (Double)GeneralModConfig.MA_TIER_PCT.get();
        }
        return PCT_ALLOWED;
    }

    public static int getCompletePerTier(int tier) {
        return (int)Math.max(Math.round((double)ProgressionHelper.getConditionsForTier(tier).size() * ProgressionHelper.getPctAllowed()), 1L);
    }

    public static List<ProgressionCondition<?>> getConditionsForTier(int tier) {
        return Registries.Progression.getValues().stream().filter(p -> p.getTier() == tier).collect(Collectors.toList());
    }

    public static <T extends Event> List<ProgressionCondition<?>> getConditionsForTierExcluding(int tier, ProgressionCondition.EventType<T> type, List<ResourceLocation> toExclude) {
        return Registries.Progression.getValues().stream().filter(p -> p.getTier() == tier && p.getType() == type && !toExclude.contains(p.getRegistryName())).collect(Collectors.toList());
    }
}

