/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.ItemAndPatternRecipe;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public abstract class ItemAndPatternRecipeSerializer<T extends ItemAndPatternRecipe>
extends AMRecipeBaseSerializer<T> {
    public ItemAndPatternRecipeSerializer(Function<ResourceLocation, T> patternMap) {
        super(patternMap);
    }

    @Override
    public T readExtra(ResourceLocation recipeId, JsonObject json) {
        T recipe = this.instantiate(recipeId);
        ((AMRecipeBase)recipe).parseJSON(json);
        return recipe;
    }

    @Override
    public T readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            T recipe = this.instantiate(recipeId);
            ((ItemAndPatternRecipe)recipe).setOutput(buffer.func_192575_l());
            ((ItemAndPatternRecipe)recipe).outputQuantity = Math.max(buffer.readInt(), 1);
            int numItems = buffer.readInt();
            ResourceLocation[] requiredItems = new ResourceLocation[numItems];
            for (int i = 0; i < numItems; ++i) {
                requiredItems[i] = buffer.func_192575_l();
            }
            ((ItemAndPatternRecipe)recipe).setRequiredItems(requiredItems);
            int numPatterns = buffer.readInt();
            ResourceLocation[] requiredPatterns = new ResourceLocation[numPatterns];
            for (int i = 0; i < numPatterns; ++i) {
                requiredPatterns[i] = buffer.func_192575_l();
            }
            ((ItemAndPatternRecipe)recipe).setRequiredPatterns(requiredPatterns);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading item and pattern recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, ItemAndPatternRecipe recipe) {
        try {
            int i;
            buffer.func_192572_a(recipe.getOutput());
            buffer.writeInt(recipe.outputQuantity);
            ResourceLocation[] items = recipe.getRequiredItems();
            ResourceLocation[] patterns = recipe.getRequiredPatterns();
            buffer.writeInt(items.length);
            for (i = 0; i < items.length; ++i) {
                buffer.func_192572_a(items[i]);
            }
            buffer.writeInt(patterns.length);
            for (i = 0; i < patterns.length; ++i) {
                buffer.func_192572_a(patterns[i]);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing item and pattern recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    protected abstract T instantiate(ResourceLocation var1);
}

