/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.multiblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MultiblockConfiguration {
    String identifier;
    HashMap<Long, Pair<Integer, MutableBoolean>> structureBlocks;
    private static final Pair<Integer, MutableBoolean> DEFAULT = new Pair((Object)-1, (Object)new MutableBoolean(false));
    private BlockPos size;
    private boolean cachedMapped = false;
    private Rotation curRotation = Rotation.NONE;
    private boolean isValid = false;

    private MultiblockConfiguration() {
        this.structureBlocks = new HashMap();
    }

    public void rotate(Rotation rotation) {
        if (rotation == this.curRotation) {
            return;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<Long> getOffsets() {
        return this.structureBlocks.keySet();
    }

    public Vector3i getSize() {
        return this.size;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public int countBlocks() {
        return this.structureBlocks.size();
    }

    public void resetMatchData() {
        this.structureBlocks.values().forEach(p -> ((MutableBoolean)p.getSecond()).setFalse());
        this.cachedMapped = false;
    }

    public Integer getBlockAt(BlockPos offset) {
        return (Integer)this.structureBlocks.getOrDefault(offset.func_218275_a(), DEFAULT).getFirst();
    }

    public void setBlockAt(BlockPos offset, Integer blockStateIndex) {
        this.structureBlocks.put(offset.func_218275_a(), (Pair<Integer, MutableBoolean>)new Pair((Object)blockStateIndex, (Object)new MutableBoolean(false)));
        this.recalculateSize();
    }

    private void recalculateSize() {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        int minZ = 0;
        int maxZ = 0;
        for (Long l : this.structureBlocks.keySet()) {
            BlockPos cur = BlockPos.func_218283_e((long)l);
            if (cur.func_177958_n() < minX) {
                minX = cur.func_177958_n();
            } else if (cur.func_177958_n() > maxX) {
                maxX = cur.func_177958_n();
            }
            if (cur.func_177956_o() < minY) {
                minY = cur.func_177956_o();
            } else if (cur.func_177956_o() > maxY) {
                maxY = cur.func_177956_o();
            }
            if (cur.func_177952_p() < minZ) {
                minZ = cur.func_177952_p();
                continue;
            }
            if (cur.func_177952_p() <= maxZ) continue;
            maxZ = cur.func_177952_p();
        }
        this.size = new BlockPos(maxX - minX, maxY - minY, maxZ - minZ);
    }

    public void validate() {
        if (this.size.func_177958_n() == 0 || this.size.func_177956_o() == 0 || this.size.func_177952_p() == 0) {
            this.isValid = false;
            return;
        }
        if (this.structureBlocks.size() == 0) {
            this.isValid = false;
            return;
        }
        this.isValid = true;
    }

    public void markMatch(BlockPos offset) {
        Pair<Integer, MutableBoolean> pair = this.structureBlocks.get(offset.func_218275_a());
        ((MutableBoolean)pair.getSecond()).setTrue();
    }

    private boolean offsetMatched(Long offset) {
        return ((MutableBoolean)this.structureBlocks.getOrDefault(offset, DEFAULT).getSecond()).booleanValue();
    }

    public void computeMatch() {
        this.cachedMapped = this.structureBlocks.values().stream().allMatch(e -> ((MutableBoolean)e.getSecond()).isTrue());
    }

    public boolean matched() {
        return this.cachedMapped;
    }

    public Pair<Integer, Integer> matchCount(List<MultiblockConfiguration> variations) {
        int total = this.structureBlocks.size();
        int matched = (int)this.structureBlocks.entrySet().stream().filter(e -> ((MutableBoolean)((Pair)e.getValue()).getSecond()).isTrue() || variations.stream().anyMatch(v -> v.offsetMatched((Long)e.getKey()))).count();
        return new Pair((Object)matched, (Object)total);
    }

    private static int updateBlockStateIndex(BlockState state, List<BlockState> blockIndex, boolean allowAir) {
        if (state.func_196958_f() && !allowAir) {
            return -1;
        }
        int index = blockIndex.indexOf(state);
        if (index == -1) {
            blockIndex.add(state);
            index = blockIndex.size() - 1;
        }
        return index;
    }

    public static MultiblockConfiguration parseVariation(JsonObject variation, List<BlockState> blockIndex) {
        MultiblockConfiguration mbc = new MultiblockConfiguration();
        if (variation.has("id") && variation.has("data")) {
            mbc.identifier = variation.get("id").getAsString();
            mbc.isValid = true;
            JsonArray data = variation.getAsJsonArray("data");
            int[] min = new int[]{0, 0, 0};
            int[] max = new int[]{0, 0, 0};
            data.forEach(d -> {
                JsonObject elem = d.getAsJsonObject();
                CompoundNBT nbt = null;
                try {
                    nbt = JsonToNBT.func_180713_a((String)elem.toString());
                }
                catch (CommandSyntaxException ex) {
                    mbc.isValid = false;
                    return;
                }
                if (nbt.func_150297_b("offset", 10) && nbt.func_150297_b("state", 10)) {
                    BlockPos offset = NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)nbt.func_74781_a("offset")));
                    BlockState state = NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)nbt.func_74781_a("state")));
                    int index = MultiblockConfiguration.updateBlockStateIndex(state, blockIndex, true);
                    if (index == -1) {
                        mbc.isValid = false;
                        return;
                    }
                    if (offset.func_177958_n() < min[0]) {
                        min[0] = offset.func_177958_n();
                    }
                    if (offset.func_177956_o() < min[1]) {
                        min[1] = offset.func_177956_o();
                    }
                    if (offset.func_177952_p() < min[2]) {
                        min[2] = offset.func_177952_p();
                    }
                    if (offset.func_177958_n() > max[0]) {
                        max[0] = offset.func_177958_n();
                    }
                    if (offset.func_177956_o() > max[1]) {
                        max[1] = offset.func_177956_o();
                    }
                    if (offset.func_177952_p() > max[2]) {
                        max[2] = offset.func_177952_p();
                    }
                    mbc.structureBlocks.put(offset.func_218275_a(), (Pair<Integer, MutableBoolean>)new Pair((Object)index, (Object)new MutableBoolean(false)));
                } else {
                    mbc.isValid = false;
                }
            });
            mbc.size = new BlockPos(max[0] - min[0], max[1] - min[1], max[2] - min[2]);
        }
        return mbc;
    }

    public static MultiblockConfiguration loadStructure(TemplateManager manager, ResourceLocation structureFile, List<BlockState> blockIndex) {
        MultiblockConfiguration mbc = new MultiblockConfiguration();
        Template template = manager.func_200219_b(structureFile);
        mbc.size = template.func_186259_a();
        template.field_204769_a.forEach(p -> p.func_237157_a_().forEach(bi -> {
            int index = MultiblockConfiguration.updateBlockStateIndex(bi.field_186243_b, blockIndex, false);
            if (index == -1) {
                return;
            }
            mbc.structureBlocks.put(bi.field_186242_a.func_218275_a(), (Pair<Integer, MutableBoolean>)new Pair((Object)index, (Object)new MutableBoolean(false)));
        }));
        mbc.isValid = true;
        return mbc;
    }

    public static MultiblockConfiguration createDummyStructure() {
        MultiblockConfiguration mbc = new MultiblockConfiguration();
        mbc.size = new BlockPos(0, 0, 0);
        mbc.isValid = false;
        return mbc;
    }

    public CompoundNBT serialize() {
        CompoundNBT data = new CompoundNBT();
        if (!this.isValid) {
            return data;
        }
        ListNBT list = new ListNBT();
        this.structureBlocks.forEach((l, i) -> {
            CompoundNBT entry = new CompoundNBT();
            entry.func_74772_a("offset", l.longValue());
            entry.func_74768_a("index", ((Integer)i.getFirst()).intValue());
            list.add((Object)entry);
        });
        data.func_218657_a("list", (INBT)list);
        if (this.size != null) {
            data.func_218657_a("size", (INBT)NBTUtil.func_186859_a((BlockPos)this.size));
        }
        return data;
    }

    public static MultiblockConfiguration deserialize(CompoundNBT nbt) {
        MultiblockConfiguration conf = new MultiblockConfiguration();
        conf.isValid = true;
        if (nbt.func_74764_b("list")) {
            ListNBT list = nbt.func_150295_c("list", 10);
            list.forEach(e -> {
                CompoundNBT entry = (CompoundNBT)e;
                if (entry.func_74764_b("offset") && entry.func_74764_b("index")) {
                    long offset = entry.func_74763_f("offset");
                    int index = entry.func_74762_e("index");
                    conf.structureBlocks.put(offset, (Pair<Integer, MutableBoolean>)new Pair((Object)index, (Object)new MutableBoolean(false)));
                }
            });
        } else {
            conf.isValid = false;
        }
        if (nbt.func_74764_b("size")) {
            conf.size = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("size"));
        } else {
            conf.isValid = false;
        }
        return conf;
    }

    public JsonObject computeRecipeDiff(MultiblockConfiguration other, ArrayList<BlockState> blockIndex) {
        HashMap changes = new HashMap();
        other.structureBlocks.keySet().stream().forEach(k -> {
            if (this.structureBlocks.containsKey(k)) {
                if (this.structureBlocks.get(k).getFirst() != other.structureBlocks.get(k).getFirst()) {
                    changes.put(k, other.structureBlocks.get(k).getFirst());
                }
            } else {
                changes.put(k, other.structureBlocks.get(k).getFirst());
            }
        });
        ListNBT diffData = new ListNBT();
        changes.entrySet().stream().forEach(e -> {
            BlockPos offset = BlockPos.func_218283_e((long)((Long)e.getKey()));
            BlockState state = (BlockState)blockIndex.get((Integer)e.getValue());
            CompoundNBT diffItem = new CompoundNBT();
            diffItem.func_218657_a("offset", (INBT)NBTUtil.func_186859_a((BlockPos)offset));
            diffItem.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)state));
            diffData.add((Object)diffItem);
        });
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", "variation_id_here_must_be_unique");
        nbt.func_218657_a("data", (INBT)diffData);
        return new JsonParser().parse(nbt.toString()).getAsJsonObject();
    }
}

