/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.runeforging;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RuneforgingRecipeSerializer
extends AMRecipeBaseSerializer<RuneforgingRecipe> {
    public RuneforgingRecipeSerializer(Function<ResourceLocation, RuneforgingRecipe> patternMap) {
        super(patternMap);
    }

    @Override
    public RuneforgingRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        RuneforgingRecipe recipe = new RuneforgingRecipe(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }

    @Override
    public RuneforgingRecipe readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            RuneforgingRecipe recipe = new RuneforgingRecipe(recipeId);
            recipe.setPatternResource(buffer.func_192575_l());
            recipe.setOutputResource(buffer.func_192575_l());
            recipe.setMaterial(buffer.func_192575_l());
            recipe.setHits(buffer.readInt());
            recipe.setOutputQuantity(buffer.readInt());
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading runeforging recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, RuneforgingRecipe recipe) {
        try {
            buffer.func_192572_a(recipe.getPatternResource());
            buffer.func_192572_a(recipe.getOutputResource());
            buffer.func_192572_a(recipe.getMaterial());
            buffer.writeInt(recipe.getHits());
            buffer.writeInt(recipe.getOutputQuantity());
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing runeforging recipe from packet.", (Throwable)e);
            throw e;
        }
    }
}

