/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.runeforging;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.runeforging.RunescribingRecipe;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RunescribingRecipeSerializer
extends AMRecipeBaseSerializer<RunescribingRecipe> {
    public static HashMap<ResourceLocation, RunescribingRecipe> ALL_RECIPES = new HashMap();

    public RunescribingRecipeSerializer(Function<ResourceLocation, RunescribingRecipe> patternMap) {
        super(patternMap);
    }

    @Override
    public RunescribingRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        RunescribingRecipe recipe = new RunescribingRecipe(recipeId);
        recipe.parseJSON(json);
        ALL_RECIPES.put(recipeId, recipe);
        return recipe;
    }

    @Override
    public RunescribingRecipe readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            RunescribingRecipe recipe = new RunescribingRecipe(recipeId);
            recipe.setHMutex(buffer.readLong());
            recipe.setVMutex(buffer.readLong());
            recipe.setOutputResource(buffer.func_218666_n());
            ALL_RECIPES.put(recipeId, recipe);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading runescribing recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, RunescribingRecipe recipe) {
        try {
            buffer.writeLong(recipe.getHMutex());
            buffer.writeLong(recipe.getVMutex());
            buffer.func_180714_a(recipe.getOutputResource().toString());
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing runescribing recipe from packet.", (Throwable)e);
            throw e;
        }
    }
}

