/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.contexts;

import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IRitualRecipe;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.entities.rituals.EntityRitual;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualContext
implements IRitualContext {
    private PlayerEntity caster;
    private EntityRitual ritual;

    public RitualContext(PlayerEntity caster, EntityRitual ritual) {
        this.caster = caster;
        this.ritual = ritual;
    }

    @Override
    public PlayerEntity getCaster() {
        return this.caster;
    }

    @Override
    public IRitualRecipe getRecipe() {
        return this.ritual.getCurrentRitual();
    }

    @Override
    public NonNullList<RitualBlockPos> getAllPositions() {
        return this.ritual.getRitualData((byte)0);
    }

    @Override
    public NonNullList<RitualBlockPos> getIndexedPositions() {
        return this.ritual.getRitualData((byte)1);
    }

    @Override
    public BlockPos getCenter() {
        return this.ritual.func_233580_cy_();
    }

    @Override
    public List<ItemStack> getCollectedReagents() {
        return this.ritual.getCollectedReagents();
    }

    @Override
    public List<ItemStack> getCollectedReagents(Predicate<ItemStack> filter) {
        return this.ritual.getCollectedReagents().stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public List<ResourceLocation> getCollectedPatterns() {
        return this.ritual.getCollectedPatterns();
    }

    @Override
    public List<ResourceLocation> getCollectedPatterns(Predicate<ResourceLocation> filter) {
        return this.ritual.getCollectedPatterns().stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public World getWorld() {
        return this.ritual.field_70170_p;
    }

    @Override
    public void replaceReagents(ResourceLocation key, NonNullList<ResourceLocation> replacements) {
        ManaAndArtifice.LOGGER.warn("RitualContext replaceReagents called outside replace reagents stage.");
    }

    @Override
    public void replaceReagents(ResourceLocation key, ResourceLocation replacement) {
        ManaAndArtifice.LOGGER.warn("RitualContext replaceReagents called outside replace reagents stage.");
    }

    @Override
    public void replacePatterns(NonNullList<ResourceLocation> replacements) {
        ManaAndArtifice.LOGGER.warn("RitualContext replacePatterns called outside replace reagents stage.");
    }

    @Override
    public void appendPatterns(NonNullList<ResourceLocation> append) {
        ManaAndArtifice.LOGGER.warn("RitualContext replacePatterns called outside replace reagents stage.");
    }
}

