/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.contexts;

import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IRitualRecipe;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.entities.rituals.EntityRitual;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class RitualReagentReplaceContext
implements IRitualContext {
    private PlayerEntity caster;
    private EntityRitual ritual;
    private NonNullList<RitualBlockPos> positions;

    public RitualReagentReplaceContext(PlayerEntity caster, EntityRitual ritual, NonNullList<RitualBlockPos> positions) {
        this.caster = caster;
        this.ritual = ritual;
        this.positions = positions;
    }

    @Override
    public PlayerEntity getCaster() {
        return this.caster;
    }

    @Override
    public IRitualRecipe getRecipe() {
        return this.ritual.getCurrentRitual();
    }

    @Override
    public NonNullList<RitualBlockPos> getAllPositions() {
        return this.ritual.getRitualData((byte)0);
    }

    @Override
    public NonNullList<RitualBlockPos> getIndexedPositions() {
        return this.ritual.getRitualData((byte)1);
    }

    @Override
    public BlockPos getCenter() {
        return this.ritual.func_233580_cy_();
    }

    @Override
    public List<ItemStack> getCollectedReagents() {
        ManaAndArtifice.LOGGER.warn("RitualContext getCollectedReagents called during replace reagents stage.");
        return new ArrayList<ItemStack>();
    }

    @Override
    public List<ItemStack> getCollectedReagents(Predicate<ItemStack> filter) {
        ManaAndArtifice.LOGGER.warn("RitualContext getCollectedReagents called during replace reagents stage.");
        return new ArrayList<ItemStack>();
    }

    @Override
    public List<ResourceLocation> getCollectedPatterns() {
        ManaAndArtifice.LOGGER.warn("RitualContext getCollectedReagents called during replace reagents stage.");
        return new ArrayList<ResourceLocation>();
    }

    @Override
    public List<ResourceLocation> getCollectedPatterns(Predicate<ResourceLocation> filter) {
        ManaAndArtifice.LOGGER.warn("RitualContext getCollectedReagents called during replace reagents stage.");
        return new ArrayList<ResourceLocation>();
    }

    public ServerWorld getWorld() {
        return (ServerWorld)this.ritual.field_70170_p;
    }

    @Override
    public void replaceReagents(ResourceLocation key, NonNullList<ResourceLocation> replacements) {
        if (this.positions.size() == 0 || replacements.size() == 0) {
            return;
        }
        int replaceIndex = 0;
        for (RitualBlockPos reagent : this.positions) {
            if (reagent == null || !reagent.isPresent() || !reagent.getReagent().isDynamic() || reagent.getReagent().getResourceLocation().compareTo(key) != 0) continue;
            reagent.getReagent().setResourceLocation((ResourceLocation)replacements.get(replaceIndex));
            if (++replaceIndex < replacements.size()) continue;
            return;
        }
    }

    @Override
    public void replaceReagents(ResourceLocation key, ResourceLocation replacement) {
        if (this.positions.size() == 0) {
            return;
        }
        for (RitualBlockPos reagent : this.positions) {
            if (reagent == null || !reagent.isPresent() || !reagent.getReagent().isDynamic() || reagent.getReagent().getResourceLocation().compareTo(key) != 0) continue;
            reagent.getReagent().setResourceLocation(replacement);
        }
    }

    @Override
    public void replacePatterns(NonNullList<ResourceLocation> replacements) {
        this.ritual.getRequiredPatterns().clear();
        this.ritual.getRequiredPatterns().addAll(replacements);
    }

    @Override
    public void appendPatterns(NonNullList<ResourceLocation> append) {
        this.ritual.getRequiredPatterns().addAll(append);
    }
}

