/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.summon.EntityAnimusBlock;
import com.ma.tools.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ComponentAnimus
extends Component {
    public ComponentAnimus(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 10.0f, 5.0f, 60.0f, 5.0f, 2.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!source.isPlayerCaster()) {
            return ComponentApplicationResult.FAIL;
        }
        if (context.countAffectedBlocks(this) > 0) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isBlock()) {
            BlockState state = context.getWorld().func_180495_p(target.getBlock());
            if (!context.getWorld().func_175623_d(target.getBlock()) && context.getWorld().func_204610_c(target.getBlock()).func_206888_e() && !state.func_177230_c().hasTileEntity(state) && BlockUtils.canDestroyBlock((LivingEntity)source.getPlayer(), (World)context.getWorld(), target.getBlock(), 3, ToolType.AXE, ToolType.PICKAXE, ToolType.SHOVEL)) {
                EntityAnimusBlock animatedBlockEntity = new EntityAnimusBlock((World)context.getWorld(), state, target.getBlock(), (int)modificationData.getValue(Attribute.DURATION) * 20);
                context.getWorld().func_217376_c((Entity)animatedBlockEntity);
                target.overrideSpellTarget((Entity)animatedBlockEntity);
                return ComponentApplicationResult.SUCCESS;
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WATER;
    }

    @Override
    public float initialComplexity() {
        return 60.0f;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.ANCIENT_WIZARDS;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

