/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ComponentGrow
extends Component {
    private List<SpellReagent> reagents = new ArrayList<SpellReagent>();

    public ComponentGrow(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
        this.reagents.add(new SpellReagent(new ItemStack((IItemProvider)Items.field_196106_bc), false, true, true));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isBlock()) {
            ItemStack bmStack = new ItemStack((IItemProvider)Items.field_196106_bc);
            BoneMealItem.applyBonemeal((ItemStack)bmStack, (World)context.getWorld(), (BlockPos)target.getBlock(), (PlayerEntity)(source.isPlayerCaster() ? source.getPlayer() : FakePlayerFactory.getMinecraft((ServerWorld)context.getWorld())));
            BoneMealItem.func_203173_b((ItemStack)bmStack, (World)context.getWorld(), (BlockPos)target.getBlock(), (Direction)target.getBlockFace(this));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.WATER;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WATER;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 1) {
            return;
        }
        BlockPos imp = new BlockPos(impact_position);
        for (int i = 0; i < 10; ++i) {
            world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), (double)imp.func_177958_n() + 0.5, (double)imp.func_177956_o() + 0.5, (double)imp.func_177952_p() + 0.5, 0.1568627506494522, (double)0.3882353f, 0.21960784494876862);
        }
    }

    @Override
    public List<SpellReagent> getRequiredReagents(@Nullable PlayerEntity caster) {
        if (caster == null) {
            return this.reagents;
        }
        MutableBoolean isFey = new MutableBoolean(false);
        caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> isFey.setValue(p.getAlliedFaction() == Faction.FEY_COURT));
        return isFey.booleanValue() ? null : this.reagents;
    }

    @Override
    public boolean canBeChanneled() {
        return true;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public float initialComplexity() {
        return 50.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 325;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

