/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentHeal
extends Component {
    public ComponentHeal(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 20.0f, 1.0f, 7.5f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!target.isEntity() || !(target.getEntity() instanceof LivingEntity)) {
            return ComponentApplicationResult.FAIL;
        }
        float magnitude = modificationData.getValue(Attribute.MAGNITUDE);
        if (target.getLivingEntity().func_70668_bt() == CreatureAttribute.field_223223_b_) {
            target.getLivingEntity().func_70097_a(DamageSource.field_76376_m, magnitude);
        } else {
            target.getLivingEntity().func_70691_i(magnitude);
        }
        if (magnitude >= 15.0f && target.getEntity() instanceof ZombieVillagerEntity) {
            ((ZombieVillagerEntity)target.getEntity()).func_191991_a(source.isPlayerCaster() ? source.getPlayer().func_110124_au() : null, 20);
        }
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 0.4f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d velocity = new Vector3d(0.0, Math.random() * (double)v, 0.0);
            world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public float initialComplexity() {
        return 40.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.FEY_COURT;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

