/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.sorcery.EntityRift;
import com.ma.gui.containers.providers.NamedRift;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ComponentRift
extends Component {
    public ComponentRift(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (context.countAffectedBlocks(this) + context.countAffectedEntities(this) > 0) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isBlock()) {
            BlockPos p = target.getBlock().func_177971_a(target.getBlockFace(this).func_176730_m());
            for (int count = 0; count < 5 && !context.getWorld().func_175623_d(p); ++count) {
                p = p.func_177984_a();
            }
            this.spawnRift((World)context.getWorld(), p);
            return ComponentApplicationResult.SUCCESS;
        }
        if (target.isLivingEntity()) {
            if (source.isPlayerCaster() && target.getLivingEntity() == source.getCaster()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)source.getPlayer()), (INamedContainerProvider)new NamedRift());
            } else {
                BlockPos p = target.getLivingEntity().func_233580_cy_().func_177984_a();
                this.spawnRift((World)context.getWorld(), p);
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    private void spawnRift(World world, BlockPos pos) {
        EntityRift rift = new EntityRift((EntityType)EntityInit.RIFT.get(), world);
        rift.func_70107_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        world.func_217376_c((Entity)rift);
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ENDER;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        Vector3d rotationOffset = new Vector3d(0.5, 0.0, 0.0);
        BlockPos bp = new BlockPos(impact_position);
        for (int angle = 0; angle < 360; angle += 30) {
            Vector3d point = rotationOffset.func_178785_b((float)((double)angle * Math.PI / 180.0));
            world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (double)((float)bp.func_177958_n() + 0.5f) + point.field_72450_a, (double)bp.func_177956_o(), (double)((float)bp.func_177952_p() + 0.5f) + point.field_72449_c, (double)((float)bp.func_177958_n() + 0.5f), (double)bp.func_177956_o(), (double)((float)bp.func_177952_p() + 0.5f));
        }
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public float initialComplexity() {
        return 30.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

