/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.boss.EntityPumpkinKing;
import com.ma.events.seasonal.SeasonalHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;

public class ComponentShear
extends Component {
    public ComponentShear(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!source.isPlayerCaster()) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isEntity()) {
            this.shearEntity(context.getWorld(), source.getPlayer(), target.getEntity(), source.getHand());
        } else if (target.isBlock()) {
            this.shearBlock(source, target, context);
        } else {
            return ComponentApplicationResult.FAIL;
        }
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SoundEvents.field_226133_ah_;
    }

    private void shearBlock(SpellSource source, SpellTarget target, SpellContext context) {
        if (context.isClientSide()) {
            return;
        }
        if (this.shearSpecial(context.getWorld(), target.getBlock(), target.getBlockFace(this))) {
            return;
        }
        BlockState targetState = context.getWorld().func_180495_p(target.getBlock());
        ItemStack heldItem = source.getPlayer().func_184586_b(source.getHand());
        if (targetState.func_177230_c() instanceof IForgeShearable) {
            this.shearIForgeShearable((IForgeShearable)targetState.func_177230_c(), source.getPlayer(), target.getBlock(), heldItem, (World)context.getWorld());
        }
        ServerWorld world = context.getWorld();
        FakePlayer entity = FakePlayerFactory.getMinecraft((ServerWorld)world);
        entity.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151097_aZ));
        TileEntity te = world.func_175625_s(target.getBlock());
        if (te != null && (world.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() || te instanceof TileEntityWithInventory)) {
            return;
        }
        entity.func_70107_b((double)target.getBlock().func_177958_n(), (double)target.getBlock().func_177956_o(), (double)target.getBlock().func_177952_p());
        BlockRayTraceResult brtr = new BlockRayTraceResult(new Vector3d((double)target.getBlock().func_177958_n() + 0.5, (double)target.getBlock().func_177956_o() + 0.5, (double)target.getBlock().func_177952_p() + 0.5), target.getBlockFace(this), target.getBlock(), true);
        world.func_180495_p(target.getBlock()).func_227031_a_((World)world, (PlayerEntity)entity, Hand.MAIN_HAND, brtr);
    }

    private void shearEntity(ServerWorld world, PlayerEntity player, Entity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof IForgeShearable) {
            this.shearIForgeShearable((IForgeShearable)entity, player, entity.func_233580_cy_(), player.func_184586_b(hand), (World)world);
        }
    }

    private void shearIForgeShearable(IForgeShearable target, PlayerEntity player, BlockPos pos, ItemStack heldItem, World world) {
        if (target.isShearable(heldItem, world, pos)) {
            List drops = target.onSheared(player, heldItem, world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem));
            Random rand = new Random();
            drops.forEach(d -> {
                ItemEntity ent = new ItemEntity(world, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + Math.random(), d);
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                world.func_217376_c((Entity)ent);
            });
        }
    }

    private boolean shearSpecial(ServerWorld world, BlockPos pos, Direction face) {
        if (!SeasonalHelper.isHalloween()) {
            return false;
        }
        if (world.func_217394_a((EntityType)EntityInit.PUMPKIN_KING.get(), new AxisAlignedBB(pos).func_186662_g(16.0), e -> true).size() != 0) {
            return false;
        }
        for (int i = 1; i < 5; ++i) {
            if (world.func_175623_d(pos.func_177981_b(i))) continue;
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150423_aK) {
            world.func_217377_a(pos, false);
            EntityPumpkinKing eds = new EntityPumpkinKing((World)world);
            eds.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
            eds.setupSpawn();
            switch (face) {
                case EAST: {
                    eds.field_70177_z = 270.0f;
                    break;
                }
                case NORTH: {
                    eds.field_70177_z = -180.0f;
                    break;
                }
                case SOUTH: {
                    eds.field_70177_z = 0.0f;
                    break;
                }
                default: {
                    eds.field_70177_z = 90.0f;
                }
            }
            eds.field_70126_B = eds.field_70177_z;
            eds.field_70761_aq = eds.field_70177_z;
            eds.field_70760_ar = eds.field_70177_z;
            world.func_217376_c((Entity)eds);
            return true;
        }
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

