/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.items.ItemInit;
import com.ma.items.sorcery.bound.ItemBoundSword;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShapeBoundSword
extends Shape {
    public ShapeBoundSword(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DAMAGE, 6.0f, 0.0f, 11.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.RANGE, 0.0f, 0.0f, 3.0f, 1.0f, 8.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modifiedData, ISpellDefinition recipe) {
        if (source.getCaster() == null || !source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        ItemStack held = source.getPlayer().func_184586_b(source.getHand());
        ItemStack replacement = ((ItemBoundSword)ItemInit.BOUND_SWORD.get()).createFromSpell(held, recipe);
        int slot = source.getHand() == Hand.MAIN_HAND ? 98 : 99;
        source.getPlayer().func_174820_d(slot, replacement);
        return Arrays.asList(new SpellTarget((Entity)source.getCaster()));
    }

    @Override
    public float initialComplexity() {
        return 5.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public boolean canBeOnRandomStaff() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

