/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.sorcery.targeting.EntitySpellProjectile;
import com.ma.items.ItemInit;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShapeProjectile
extends Shape {
    public ShapeProjectile(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RADIUS, 0.0f, 0.0f, 3.0f, 1.0f), new AttributeValuePair(Attribute.SPEED, 1.0f, 1.0f, 3.0f, 0.2f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        if (source == null) {
            return Arrays.asList(SpellTarget.NONE);
        }
        EntitySpellProjectile projectile = new EntitySpellProjectile(source.getCaster(), world);
        CompoundNBT nbt = new CompoundNBT();
        recipe.writeToNBT(nbt);
        projectile.setSpellRecipe(nbt);
        projectile.shoot((Entity)source.getCaster(), source.getForward(), modificationData.getValue(Attribute.SPEED), 0.0f);
        if (source.isPlayerCaster() && source.getPlayer().func_184586_b(source.getHand()).func_77973_b() == ItemInit.PUNKIN_STAFF.get()) {
            projectile.setSpecialRender(EntitySpellProjectile.SpecialRenderType.HALLOWEEN);
        }
        world.func_217376_c((Entity)projectile);
        return Arrays.asList(new SpellTarget((Entity)source.getCaster()));
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

