/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.sorcery.targeting.EntitySpellWall;
import com.ma.spells.shapes.ShapeRaytrace;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ShapeWall
extends ShapeRaytrace {
    public ShapeWall(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 3.0f, 1.0f, 10.0f, 0.5f, 10.0f), new AttributeValuePair(Attribute.WIDTH, 3.0f, 1.0f, 9.0f, 1.0f, 3.0f), new AttributeValuePair(Attribute.HEIGHT, 2.0f, 1.0f, 9.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.RANGE, 8.0f, 8.0f, 32.0f, 1.0f, 2.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        if (!source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        List<SpellTarget> tgts = super.Target(source, world, modificationData, recipe);
        SpellTarget tgt = tgts.get(0);
        if (tgt == SpellTarget.NONE) {
            return tgts;
        }
        if (!world.field_72995_K) {
            EntitySpellWall projectile = new EntitySpellWall(source.getPlayer(), recipe, world);
            if (tgt.isBlock()) {
                BlockPos pos = tgt.getBlock().func_177972_a(tgt.getBlockFace(null));
                projectile.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
            } else if (tgt.isEntity()) {
                projectile.func_70107_b(tgt.getEntity().func_226277_ct_(), tgt.getEntity().func_226278_cu_(), tgt.getEntity().func_226281_cx_());
            }
            world.func_217376_c((Entity)projectile);
        }
        return Arrays.asList(new SpellTarget((Entity)source.getPlayer()));
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public boolean isChanneled() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 12000;
    }
}

