/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.commons.lang3.mutable.MutableObject;

public class TeleportHelper {
    private static void teleport(Entity entityIn, ServerWorld worldIn, double x, double y, double z, float yaw, float pitch) {
        EnumSet<SPlayerPositionLookPacket.Flags> set = EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class);
        set.add(SPlayerPositionLookPacket.Flags.X_ROT);
        set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
        if (entityIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity spe = (ServerPlayerEntity)entityIn;
            ChunkPos chunkPos = new ChunkPos(new BlockPos(x, y, z));
            worldIn.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkPos, 1, (Object)entityIn.func_145782_y());
            entityIn.func_184210_p();
            if (spe.func_70608_bn()) {
                spe.func_225652_a_(true, true);
            }
            if (worldIn == entityIn.field_70170_p) {
                spe.field_71135_a.func_175089_a(x, y, z, yaw, pitch, set);
            } else {
                spe.func_200619_a(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.func_70034_d(yaw);
        } else {
            float wrappedYaw = MathHelper.func_76142_g((float)yaw);
            float wrappedPitch = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)pitch), (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.field_70170_p) {
                entityIn.func_70012_b(x, y, z, wrappedYaw, wrappedPitch);
                entityIn.func_70034_d(wrappedYaw);
            } else {
                entityIn.func_213319_R();
                Entity entity = entityIn.func_200600_R().func_200721_a((World)worldIn);
                if (entity == null) {
                    return;
                }
                entity.func_180432_n(entityIn);
                entity.func_70012_b(x, y, z, wrappedYaw, wrappedPitch);
                entity.func_70034_d(wrappedYaw);
                worldIn.func_217460_e(entity);
                entityIn.func_70106_y();
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).func_184613_cA()) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            entityIn.func_230245_c_(true);
        }
        if (entityIn instanceof CreatureEntity) {
            ((CreatureEntity)entityIn).func_70661_as().func_75499_g();
        }
    }

    public static void teleportEntity(Entity entity, RegistryKey<World> destType, Vector3d destPos) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        ServerWorld world = entity.func_184102_h().func_71218_a(destType);
        if (world != null) {
            TeleportHelper.teleport(entity, world, destPos.func_82615_a(), destPos.func_82617_b(), destPos.func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        } else if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_145747_a((ITextComponent)new StringTextComponent("Error looking up world key.  This is a bug!  Teleport failed."), Util.field_240973_b_);
        }
    }

    public static boolean randomTeleport(LivingEntity entity, float maxDist, int tries) {
        do {
            boolean teleported;
            double rX = entity.func_226282_d_((double)maxDist);
            double rY = entity.func_226283_e_((double)maxDist);
            double rZ = entity.func_226287_g_((double)maxDist);
            BlockPos.Mutable targetPos = new BlockPos.Mutable(rX, rY, rZ);
            while (targetPos.func_177956_o() > 0 && !entity.field_70170_p.func_180495_p((BlockPos)targetPos).func_185904_a().func_76230_c()) {
                targetPos.func_189536_c(Direction.DOWN);
            }
            BlockState blockstate = entity.field_70170_p.func_180495_p((BlockPos)targetPos);
            boolean blocksMotion = blockstate.func_185904_a().func_76230_c();
            boolean isLava = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b);
            if (!blocksMotion || isLava || !(teleported = entity.func_213373_a(rX, rY, rZ, true))) continue;
            if (!entity.func_174814_R()) {
                entity.field_70170_p.func_184148_a((PlayerEntity)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
                entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return true;
        } while (--tries >= 0);
        return false;
    }

    @Nullable
    public static ServerWorld resolveRegistryKey(ServerWorld world, RegistryKey<World> dimension) {
        return TeleportHelper.resolveRegistryKey(world, dimension.getRegistryName(), dimension.func_240901_a_());
    }

    @Nullable
    public static ServerWorld resolveRegistryKey(ServerWorld world, ResourceLocation registryName, ResourceLocation location) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)location) && world.func_234923_W_().getRegistryName().equals((Object)registryName)) {
            return world;
        }
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return null;
        }
        MutableObject targetWorld = new MutableObject(null);
        server.func_212370_w().iterator().forEachRemaining(sw -> {
            if (sw == null) {
                return;
            }
            if (sw.func_234923_W_().func_240901_a_().equals((Object)location) && sw.func_234923_W_().getRegistryName().equals((Object)registryName)) {
                targetWorld.setValue(sw);
            }
        });
        return (ServerWorld)targetWorld.getValue();
    }
}

