/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools.render;

import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.tools.render.MARenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class WorldRenderUtils {
    private static final float TRIANGLE_CONSTANT = (float)(Math.sqrt(3.0) / 2.0);
    public static final int FULL_BRIGHTNESS = 0xF000F0;

    public static void renderRadiant(float ageTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int[] innerColor, int[] outerColor, int alpha, float scale, boolean grow) {
        float rotationByAge = ageTicks / 180.0f;
        Random random = new Random(1234L);
        IVertexBuilder lightingBuilder = bufferIn.getBuffer(MARenderTypes.RADIANT_RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        if (grow) {
            float growth = 1.0f + scale * 25.0f;
            matrixStackIn.func_227862_a_(growth, growth, growth);
        } else {
            matrixStackIn.func_227862_a_(scale, scale, scale);
        }
        alpha = Math.min(alpha, 64);
        for (int i = 0; i < 40; ++i) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + 90.0f * rotationByAge));
            float hOffset = i % 3 == 0 ? random.nextFloat() * 0.55f : random.nextFloat() * 0.25f;
            float vOffset = random.nextFloat() * 0.25f;
            Matrix4f currentMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
            WorldRenderUtils.startRadiantQuad(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.addRadiantPoint_NegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.addRadiantPoint_PositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, innerColor);
            WorldRenderUtils.startRadiantQuad(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.addRadiantPoint_PositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.addRadiantPoint_AbsolutePosition(lightingBuilder, currentMatrix, hOffset, vOffset, innerColor);
            WorldRenderUtils.startRadiantQuad(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.addRadiantPoint_AbsolutePosition(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.addRadiantPoint_NegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, innerColor);
        }
        matrixStackIn.func_227865_b_();
    }

    public static void renderRadiant(Entity entityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int[] innerColor, int[] outerColor, int alpha, float scale) {
        WorldRenderUtils.renderRadiant(entityIn.field_70173_aa, matrixStackIn, bufferIn, innerColor, outerColor, alpha, scale, true);
    }

    public static void renderRadiantWithDirection(Entity entityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int[] innerColor, int[] outerColor, int alpha, float scale) {
        float rotationByAge = (float)entityIn.field_70173_aa / 220.0f;
        Random random = new Random(1234L);
        IVertexBuilder lightingBuilder = bufferIn.getBuffer(MARenderTypes.RADIANT_RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(entityIn.field_70177_z - 90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(entityIn.field_70125_A + 90.0f));
        matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
        matrixStackIn.func_227862_a_(scale, scale * 3.0f, scale);
        for (int i = 0; i < 20; ++i) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f + 90.0f * rotationByAge));
            float hOffset = random.nextFloat() * 0.25f;
            float vOffset = random.nextFloat() * 0.25f;
            Matrix4f currentMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
            WorldRenderUtils.startRadiantQuad(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.addRadiantPoint_NegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.addRadiantPoint_PositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.startRadiantQuad(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.addRadiantPoint_PositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.addRadiantPoint_AbsolutePosition(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.startRadiantQuad(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.addRadiantPoint_AbsolutePosition(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.addRadiantPoint_NegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
        }
        matrixStackIn.func_227865_b_();
    }

    public static void renderBeam(World world, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Vector3d start, Vector3d end, float lengthPct, int[] color, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, matrixStackIn, bufferIn, packedLightIn, start, end, lengthPct, color, 0.01f, renderType);
    }

    public static void renderBeam(World world, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Vector3d start, Vector3d end, float lengthPct, int[] color, float width, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, matrixStackIn, bufferIn, packedLightIn, start, end, lengthPct, color, 176, width, renderType);
    }

    public static void renderBeam(World world, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Vector3d start, Vector3d end, float lengthPct, int[] color, int alpha, float width, RenderType renderType) {
        float worldPartialTicks = (float)world.func_82737_E() + partialTicks;
        float uvSlideRate = worldPartialTicks * 0.1f % 1.0f;
        Vector3d direction = end.func_178788_d(start);
        float beamLength = (float)direction.func_72433_c() * lengthPct;
        direction = direction.func_72432_b();
        float aCosDirectionY = (float)Math.acos(direction.field_72448_b);
        float atan2DirectionXZ = (float)Math.atan2(direction.field_72449_c, direction.field_72450_a);
        float rotation = 0.0f;
        int red = color[0];
        int green = color[1];
        int blue = color[2];
        float beamWidth = width;
        float x1Start = MathHelper.func_76134_b((float)(rotation + (float)Math.PI)) * beamWidth;
        float x1End = MathHelper.func_76134_b((float)rotation) * beamWidth;
        float y1Start = MathHelper.func_76126_a((float)(rotation + (float)Math.PI)) * beamWidth;
        float y1End = MathHelper.func_76126_a((float)rotation) * beamWidth;
        float x2Start = MathHelper.func_76134_b((float)(rotation + 1.5707964f)) * beamWidth;
        float x2End = MathHelper.func_76134_b((float)(rotation + 4.712389f)) * beamWidth;
        float y2Start = MathHelper.func_76126_a((float)(rotation + 1.5707964f)) * beamWidth;
        float y2End = MathHelper.func_76126_a((float)(rotation + 4.712389f)) * beamWidth;
        float vSlide = -1.0f - uvSlideRate;
        float f30 = beamLength * 2.5f + vSlide;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - atan2DirectionXZ) * 57.295776f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(aCosDirectionY * 57.295776f));
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(renderType);
        MatrixStack.Entry activeStack = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = activeStack.func_227870_a_();
        Matrix3f normalMatrix = activeStack.func_227872_b_();
        float uMin = 0.05f;
        float uMax = 0.95f;
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1Start, beamLength, y1Start, red, green, blue, alpha, uMax, f30);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1Start, 0.0f, y1Start, red, green, blue, alpha, uMax, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1End, 0.0f, y1End, red, green, blue, alpha, uMin, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1End, beamLength, y1End, red, green, blue, alpha, uMin, f30);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2Start, beamLength, y2Start, red, green, blue, alpha, uMax, f30);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2Start, 0.0f, y2Start, red, green, blue, alpha, uMax, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2End, 0.0f, y2End, red, green, blue, alpha, uMin, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2End, beamLength, y2End, red, green, blue, alpha, uMin, f30);
        matrixStackIn.func_227865_b_();
    }

    public static void renderTexturedRectAlong(World world, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Vector3d start, Vector3d end, float width, RenderType renderType, int segments) {
        float uMin = 0.05f;
        float uMax = 0.95f;
        Vector3d direction = end.func_178788_d(start);
        Vector3d offset = direction.func_72431_c(new Vector3d(0.0, 1.0, 0.0));
    }

    public static void renderManaweavePattern(ManaweavingPattern pattern, Quaternion rotation, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        byte[][] points = pattern.get();
        float offsetX = (float)points.length / 2.0f;
        float offsetY = (float)points[0].length / 2.0f;
        float baseScale = 0.15f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 2.0, 0.0);
        matrixStackIn.func_227863_a_(rotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227861_a_(-3.6 * (double)baseScale, -3.6 * (double)baseScale, 0.0);
        matrixStackIn.func_227862_a_(baseScale, baseScale, baseScale);
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(MARenderTypes.RENDER_TYPE_MANAWEAVE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * 0.5f;
                float originY = offsetY - (float)i * 0.5f;
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 109, 227, 220, 176, 0.0f, 1.0f);
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 0.0f, 109, 227, 220, 176, 1.0f, 1.0f);
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 0.0f, 109, 227, 220, 176, 1.0f, 0.0f);
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 109, 227, 220, 176, 0.0f, 0.0f);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private static void startRadiantQuad(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, int[] rgb, int alpha) {
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_181675_d();
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(rgb[0], rgb[1], rgb[2], alpha).func_181675_d();
    }

    private static void addRadiantPoint_NegativeOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float y, float x, int[] rgb) {
        vertexBuilder.func_227888_a_(renderMatrix, -TRIANGLE_CONSTANT * x, y, -0.2f * x).func_225586_a_(rgb[0], rgb[1], rgb[2], 0).func_181675_d();
    }

    private static void addRadiantPoint_PositiveOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float y, float x, int[] rgb) {
        vertexBuilder.func_227888_a_(renderMatrix, TRIANGLE_CONSTANT * x, y, -0.2f * x).func_225586_a_(rgb[0], rgb[1], rgb[2], 0).func_181675_d();
    }

    private static void addRadiantPoint_AbsolutePosition(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float y, float z, int[] rgb) {
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, y, 1.0f * z).func_225586_a_(rgb[0], rgb[1], rgb[2], 0).func_181675_d();
    }

    private static void createVertex(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float z, int colorRed, int colorGreen, int colorBlue, int alpha, float u, float v) {
        vertexBuilder.func_227888_a_(renderMatrix, x, y, z).func_225586_a_(colorRed, colorGreen, colorBlue, alpha).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

