/*
 * Decompiled with CFR 0.152.
 */
package com.ma.villagers;

import com.google.common.collect.ImmutableList;
import com.ma.ManaAndArtifice;
import com.ma.tools.RLoc;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VillageStructures {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/spellmonger"), 4);
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/manaweaver"), 2);
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/runeforge_and_runescribe"), 2);
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/runescribe"), 2);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/spellmonger"), 4);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/manaweaver"), 2);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/runeforge_and_runescribe"), 2);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/runescribe"), 2);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/spellmonger"), 4);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/manaweaver"), 2);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/runeforge_and_runescribe"), 2);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/runescribe"), 2);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/spellmonger"), 4);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/manaweaver"), 2);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/runeforge_and_runescribe"), 2);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/runescribe"), 2);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/spellmonger"), 4);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/manaweaver"), 2);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/runeforge_and_runescribe"), 2);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/runescribe"), 2);
    }

    private static void registerTaigaVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.registerVillageStructure(new ResourceLocation("village/taiga/houses"), pieceNBTLocation, weight);
    }

    private static void registerDesertVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.registerVillageStructure(new ResourceLocation("village/desert/houses"), pieceNBTLocation, weight);
    }

    private static void registerSavannaVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.registerVillageStructure(new ResourceLocation("village/savanna/houses"), pieceNBTLocation, weight);
    }

    private static void registerSnowyVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.registerVillageStructure(new ResourceLocation("village/snowy/houses"), pieceNBTLocation, weight);
    }

    private static void registerPlainsVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.registerVillageStructure(new ResourceLocation("village/plains/houses"), pieceNBTLocation, weight);
    }

    private static void registerVillageStructure(ResourceLocation jigsawRegistryName, ResourceLocation pieceNBTLocation, int weight) {
        JigsawPiece newStructure = (JigsawPiece)JigsawPiece.func_242851_a((String)pieceNBTLocation.toString(), (StructureProcessorList)ProcessorLists.field_244107_g).apply(JigsawPattern.PlacementBehaviour.RIGID);
        Optional jigsawPattern = WorldGenRegistries.field_243656_h.func_241873_b(jigsawRegistryName);
        if (jigsawPattern.isPresent()) {
            JigsawPattern p = (JigsawPattern)jigsawPattern.get();
            p.field_214953_e = VillageStructures.fixImmutableList(p.field_214953_e);
            p.field_214952_d = VillageStructures.fixImmutableList(p.field_214952_d);
            p.field_214952_d.add(Pair.of((Object)newStructure, (Object)weight));
            for (int i = 0; i < weight; ++i) {
                p.field_214953_e.add(newStructure);
            }
        } else {
            ManaAndArtifice.LOGGER.warn("Jigsaw registry list {0} not found, skipping", (Object)jigsawRegistryName.toString());
        }
    }

    private static <T> List<T> fixImmutableList(List<T> list) {
        if (list instanceof ImmutableList) {
            ArrayList<T> copy = new ArrayList<T>();
            for (T elem : list) {
                copy.add(elem);
            }
            return copy;
        }
        return list;
    }
}

