/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix.config;

import architectury_inject_memoryleakfix_common_4c45de01ce324e94b4bf8a51285af726_908019a625e79731ac8166045ce8c92b6a8f26515bf142f6e3a5f121c9c86825memoryleakfixcommonpre117115devjar.PlatformMethods;
import ca.fxco.memoryleakfix.MemoryLeakFix;
import ca.fxco.memoryleakfix.MemoryLeakFixBootstrap;
import ca.fxco.memoryleakfix.MemoryLeakFixExpectPlatform;
import ca.fxco.memoryleakfix.config.MinecraftRequirement;
import ca.fxco.memoryleakfix.config.Remap;
import ca.fxco.memoryleakfix.config.RemapTarget;
import ca.fxco.memoryleakfix.config.Remaps;
import ca.fxco.memoryleakfix.config.SilentClassNotFound;
import ca.fxco.memoryleakfix.mixinextras.MixinExtrasBootstrap;
import ca.fxco.memoryleakfix.mixinextras.injector.ModifyExpressionValue;
import ca.fxco.memoryleakfix.mixinextras.injector.ModifyReceiver;
import ca.fxco.memoryleakfix.mixinextras.injector.ModifyReturnValue;
import ca.fxco.memoryleakfix.mixinextras.injector.WrapWithCondition;
import ca.fxco.memoryleakfix.mixinextras.injector.wrapoperation.WrapOperation;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Desc;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MemoryLeakFixMixinConfigPlugin
implements IMixinConfigPlugin {
    private final Set<String> APPLIED_MEMORY_LEAK_FIXES = new HashSet<String>();
    private static boolean shouldMentionFixCount = true;
    private static final boolean VERBOSE = false;

    public void onLoad(String mixinPackage) {
        MemoryLeakFixBootstrap.init();
        if (PlatformMethods.getCurrentTarget().contains("forge")) {
            MixinExtrasBootstrap.init();
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean shouldApply;
        if (!mixinClassName.startsWith("ca.fxco.memoryleakfix")) {
            return true;
        }
        boolean bl = shouldApply = MemoryLeakFixMixinConfigPlugin.areRequirementsMet(MemoryLeakFixMixinConfigPlugin.getMinecraftRequirement(mixinClassName)) && !this.shouldSilentNoClassDefFound(targetClassName, mixinClassName);
        if (shouldApply) {
            String classGroup = mixinClassName.substring(0, mixinClassName.lastIndexOf("."));
            this.APPLIED_MEMORY_LEAK_FIXES.add(classGroup.substring(classGroup.lastIndexOf(".") + 1));
        }
        return shouldApply;
    }

    private boolean shouldSilentNoClassDefFound(String targetClassName, String mixinClassName) {
        block4: {
            try {
                ClassNode mixinClass = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
                if (Annotations.getInvisible((ClassNode)mixinClass, SilentClassNotFound.class) == null) break block4;
                try {
                    MixinService.getService().getBytecodeProvider().getClassNode(targetClassName);
                }
                catch (ClassNotFoundException e) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
        if (shouldMentionFixCount) {
            shouldMentionFixCount = false;
            int size = this.APPLIED_MEMORY_LEAK_FIXES.size();
            if (size > 0) {
                MemoryLeakFix.LOGGER.info("[MemoryLeakFix] Will be applying " + size + " memory leak fixes!");
                MemoryLeakFix.LOGGER.info("[MemoryLeakFix] Currently enabled memory leak fixes: " + this.APPLIED_MEMORY_LEAK_FIXES);
            }
        }
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public static void runCustomMixinClassNodeAnnotations(String className, ClassNode classNode) {
        if (!className.startsWith("ca.fxco.memoryleakfix")) {
            return;
        }
        if (!MemoryLeakFixMixinConfigPlugin.areRequirementsMet(Annotations.getInvisible((ClassNode)classNode, MinecraftRequirement.class))) {
            return;
        }
        Iterator methodIterator = classNode.methods.iterator();
        while (methodIterator.hasNext()) {
            Object remaps;
            MethodNode node = (MethodNode)methodIterator.next();
            boolean isValid = true;
            AnnotationNode requirements = Annotations.getInvisible((MethodNode)node, MinecraftRequirement.class);
            if (requirements != null) {
                for (AnnotationNode versionRange : (Iterable)Annotations.getValue((AnnotationNode)requirements)) {
                    if (MemoryLeakFixMixinConfigPlugin.isVersionRangeValid(versionRange)) continue;
                    methodIterator.remove();
                    isValid = false;
                    break;
                }
            }
            if (!isValid) continue;
            AnnotationNode remapTarget = Annotations.getVisible((MethodNode)node, RemapTarget.class);
            if (remapTarget != null) {
                MemoryLeakFixMixinConfigPlugin.executeRemapAnnotation(node, (AnnotationNode)Annotations.getValue((AnnotationNode)remapTarget, (String)"value"), false);
                MemoryLeakFixMixinConfigPlugin.executeRemapAnnotation(node, (AnnotationNode)Annotations.getValue((AnnotationNode)remapTarget, (String)"target"), true);
                continue;
            }
            MemoryLeakFixMixinConfigPlugin.executeRemapAnnotation(node, Annotations.getVisible((MethodNode)node, Remap.class), false);
            AnnotationNode remapsAnnotation = Annotations.getInvisible((MethodNode)node, Remaps.class);
            if (remapsAnnotation == null || (remaps = (List)Annotations.getValue((AnnotationNode)remapsAnnotation)) == null) continue;
            Iterator iterator = remaps.iterator();
            while (iterator.hasNext()) {
                AnnotationNode remap = (AnnotationNode)iterator.next();
                MemoryLeakFixMixinConfigPlugin.executeRemapAnnotation(node, remap, false);
            }
        }
        HashMap<FieldNode, String> fieldsRemapping = new HashMap<FieldNode, String>();
        Iterator fieldIterator = classNode.fields.iterator();
        while (fieldIterator.hasNext()) {
            List mappings;
            AnnotationNode annotationNode;
            FieldNode node = (FieldNode)fieldIterator.next();
            boolean isValid = true;
            AnnotationNode requirements = Annotations.getInvisible((FieldNode)node, MinecraftRequirement.class);
            if (requirements != null) {
                for (AnnotationNode versionRange : (Iterable)Annotations.getValue((AnnotationNode)requirements)) {
                    if (MemoryLeakFixMixinConfigPlugin.isVersionRangeValid(versionRange)) continue;
                    fieldIterator.remove();
                    isValid = false;
                    break;
                }
            }
            if (!isValid || (annotationNode = Annotations.getVisible((FieldNode)node, Remap.class)) == null || Annotations.getVisible((FieldNode)node, Shadow.class) != null || (mappings = (List)Annotations.getValue((AnnotationNode)annotationNode, (String)MemoryLeakFixExpectPlatform.getMappingType())) == null || mappings.size() < 1) continue;
            if (mappings.size() > 1) {
                throw new IllegalStateException("Fields cannot contain more than 1 remap! - " + className + " - " + node.name + node.desc);
            }
            String mapping = (String)mappings.get(0);
            fieldsRemapping.put(node, mapping);
            node.name = mapping;
        }
        if (!fieldsRemapping.isEmpty()) {
            MemoryLeakFixMixinConfigPlugin.executeRemapAnnotation(className, classNode, fieldsRemapping);
        }
    }

    private static boolean areRequirementsMet(@Nullable AnnotationNode requirements) {
        if (requirements != null) {
            for (AnnotationNode versionRange : (Iterable)Annotations.getValue((AnnotationNode)requirements)) {
                if (!MemoryLeakFixMixinConfigPlugin.isVersionRangeValid(versionRange)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static AnnotationNode getMinecraftRequirement(String mixinClassName) {
        try {
            return Annotations.getInvisible((ClassNode)MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName), MinecraftRequirement.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isVersionRangeValid(AnnotationNode versionRange) {
        String minVersion = (String)Annotations.getValue((AnnotationNode)versionRange, (String)"minVersion");
        if (minVersion != null && !minVersion.isEmpty() && MemoryLeakFixExpectPlatform.compareMinecraftToVersion(minVersion) < 0) {
            return false;
        }
        String maxVersion = (String)Annotations.getValue((AnnotationNode)versionRange, (String)"maxVersion");
        return maxVersion == null || maxVersion.isEmpty() || MemoryLeakFixExpectPlatform.compareMinecraftToVersion(maxVersion) <= 0;
    }

    private static void executeRemapAnnotation(String className, ClassNode classNode, Map<FieldNode, String> fieldRemapping) {
        className = className.replace(".", "/");
        for (MethodNode methodNode : classNode.methods) {
            ListIterator it = methodNode.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)it.next();
                if (!(insn instanceof FieldInsnNode) || !((FieldInsnNode)insn).owner.equals(className)) continue;
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                for (Map.Entry<FieldNode, String> entry : fieldRemapping.entrySet()) {
                    FieldNode node = entry.getKey();
                    if (!node.name.equals(fieldInsn.name) || !node.desc.equals(fieldInsn.desc)) continue;
                    it.remove();
                    it.add(new FieldInsnNode(fieldInsn.getOpcode(), fieldInsn.owner, entry.getValue(), fieldInsn.desc));
                }
            }
        }
    }

    private static void executeRemapAnnotation(MethodNode node, @Nullable AnnotationNode remap, boolean target) {
        if (remap == null) {
            return;
        }
        boolean excludeDev = (Boolean)Annotations.getValue((AnnotationNode)remap, (String)"excludeDev", (Object)Boolean.FALSE);
        if (excludeDev && MemoryLeakFixExpectPlatform.isDevEnvironment()) {
            return;
        }
        if (!MemoryLeakFixMixinConfigPlugin.areRequirementsMet((AnnotationNode)Annotations.getValue((AnnotationNode)remap, (String)"mcVersions"))) {
            return;
        }
        List mapping = (List)Annotations.getValue((AnnotationNode)remap, (String)MemoryLeakFixExpectPlatform.getMappingType());
        if (mapping != null && !mapping.isEmpty()) {
            if (target) {
                MemoryLeakFixMixinConfigPlugin.remapMixinAnnotationTarget(node, mapping);
            } else {
                MemoryLeakFixMixinConfigPlugin.remapMixinAnnotation(node, mapping);
            }
        }
    }

    private static void remapMixinAnnotation(MethodNode node, List<String> remapped) {
        AnnotationNode annotationNode = MemoryLeakFixMixinConfigPlugin.getMixinAnnotation(node);
        if (annotationNode != null) {
            for (int i = 0; i < annotationNode.values.size() - 1; ++i) {
                Object obj = annotationNode.values.get(i);
                if (!(obj instanceof String) || !obj.equals("method")) continue;
                List methodList = (List)annotationNode.values.get(i + 1);
                annotationNode.values.set(i + 1, remapped);
            }
        }
    }

    private static void remapMixinAnnotationTarget(MethodNode node, List<String> remapped) {
        AnnotationNode annotationNode = MemoryLeakFixMixinConfigPlugin.getMixinAnnotation(node);
        if (annotationNode != null) {
            int count = 0;
            for (int i = 0; i < annotationNode.values.size(); ++i) {
                Object obj = annotationNode.values.get(i);
                if (obj instanceof At[]) {
                    At[] ats;
                    for (At at : ats = (At[])obj) {
                        annotationNode.values.set(i, MemoryLeakFixMixinConfigPlugin.alterAtTarget(at, remapped.get(count)));
                        ++count;
                    }
                    continue;
                }
                if (!(obj instanceof At)) continue;
                annotationNode.values.set(i, MemoryLeakFixMixinConfigPlugin.alterAtTarget((At)obj, remapped.get(count)));
                ++count;
            }
        }
    }

    @Nullable
    private static AnnotationNode getMixinAnnotation(MethodNode node) {
        return Annotations.getSingleVisible((MethodNode)node, (Class[])new Class[]{Inject.class, Redirect.class, ModifyArg.class, ModifyArgs.class, ModifyConstant.class, ModifyVariable.class, ModifyExpressionValue.class, ModifyReceiver.class, ModifyReturnValue.class, WrapOperation.class, WrapWithCondition.class});
    }

    private static At alterAtTarget(final At at, final String target) {
        return new At(){

            public Class<? extends Annotation> annotationType() {
                return at.annotationType();
            }

            public String id() {
                return at.id();
            }

            public String value() {
                return at.value();
            }

            public String slice() {
                return at.slice();
            }

            public At.Shift shift() {
                return at.shift();
            }

            public int by() {
                return at.by();
            }

            public String[] args() {
                return at.args();
            }

            public String target() {
                return target;
            }

            public Desc desc() {
                return at.desc();
            }

            public int ordinal() {
                return at.ordinal();
            }

            public int opcode() {
                return at.opcode();
            }

            public boolean remap() {
                return at.remap();
            }
        };
    }
}

