/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.structure.CachingStructureManager;

public class ModernFixCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"modernfix").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"upgradeStructures").requires(source -> source.func_197034_c(3))).executes(context -> {
            ServerWorld level = ((CommandSource)context.getSource()).func_197023_e();
            if (level == null) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Couldn't find server level"));
                return 0;
            }
            IResourceManager manager = level.func_73046_m().field_195576_ac.func_240970_h_();
            Collection structures = manager.func_199003_a("structures", p -> p.endsWith(".nbt"));
            int upgradedNum = 0;
            Pattern pathPattern = Pattern.compile("^structures/(.*)\\.nbt$");
            for (ResourceLocation found : structures) {
                ++upgradedNum;
                Matcher matcher = pathPattern.matcher(found.func_110623_a());
                if (!matcher.matches()) continue;
                ResourceLocation structureLocation = new ResourceLocation(found.func_110624_b(), matcher.group(1));
                try {
                    IResource resource = manager.func_199002_a(found);
                    try {
                        CachingStructureManager.readStructureTag(structureLocation, level.func_73046_m().func_195563_aC(), resource.func_199027_b());
                        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("checked " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"), false);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Throwable e) {
                    ModernFix.LOGGER.error("Couldn't upgrade structure " + found, e);
                    ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("error reading " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"));
                }
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("All structures upgraded"), false);
            return 1;
        })));
    }
}

