/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.reuse_datapacks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.codec.DatapackCodec;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.duck.reuse_datapacks.ICachingResourceClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
@ClientOnlyMixin
public abstract class MinecraftMixin
implements ICachingResourceClient {
    private DataPackRegistries cachedResources;
    private List<String> cachedDataPackConfig;
    private List<String> loadingDataPackConfig;

    @Shadow
    public abstract boolean func_71387_A();

    @Redirect(method={"makeServerStem"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;configurePackRepository(Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/world/level/DataPackConfig;Z)Lnet/minecraft/world/level/DataPackConfig;"))
    private DatapackCodec saveLoadingConfig(ResourcePackList repo, DatapackCodec inCodec, boolean vanillaOnly) {
        DatapackCodec config = MinecraftServer.func_240772_a_((ResourcePackList)repo, (DatapackCodec)inCodec, (boolean)vanillaOnly);
        this.loadingDataPackConfig = (List)repo.func_198980_d().stream().map(ResourcePackInfo::func_195790_f).collect(ImmutableList.toImmutableList());
        return config;
    }

    @Redirect(method={"makeServerStem"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/ServerResources;loadResources(Ljava/util/List;Lnet/minecraft/commands/Commands$CommandSelection;ILjava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<DataPackRegistries> useCachedResources(List<IResourcePack> list, Commands.EnvironmentType arg, int i, Executor executor, Executor executor2) {
        if (this.cachedResources != null) {
            if (this.cachedResources.func_240970_h_().func_199001_a().size() > 0) {
                if (this.cachedDataPackConfig.equals(this.loadingDataPackConfig)) {
                    ModernFix.LOGGER.warn("Reusing loaded server resources from previous world");
                    return CompletableFuture.completedFuture(this.cachedResources);
                }
                ModernFix.LOGGER.warn("Discarding cached server resources, datapack configs have changed");
                ModernFix.LOGGER.warn("Old: {}", (Object)("[" + String.join((CharSequence)", ", this.cachedDataPackConfig) + "]"));
                ModernFix.LOGGER.warn("New: {}", (Object)("[" + String.join((CharSequence)", ", this.loadingDataPackConfig) + "]"));
                this.cachedResources.close();
                this.cachedResources = null;
                this.cachedDataPackConfig = null;
            } else {
                ModernFix.LOGGER.error("Cached server resources were closed somehow, that shouldn't happen");
                this.cachedResources = null;
            }
        }
        return DataPackRegistries.func_240961_a_(list, (Commands.EnvironmentType)arg, (int)i, (Executor)executor, (Executor)executor2);
    }

    @Override
    public void setCachedResources(DataPackRegistries r) {
        this.cachedResources = r;
    }

    @Override
    public void setCachedDataPackConfig(Collection<String> c) {
        this.cachedDataPackConfig = ImmutableList.copyOf(c);
    }

    @Inject(method={"setLevel"}, at={@At(value="HEAD")})
    private void clearResourcesIfNotLocal(CallbackInfo ci) {
        if (!this.func_71387_A()) {
            this.cachedResources = null;
        }
    }
}

