/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.registry.Registry;

public class ModelLocationCache {
    private static final LoadingCache<BlockState, ModelResourceLocation> blockLocationCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<BlockState, ModelResourceLocation>(){

        public ModelResourceLocation load(BlockState key) throws Exception {
            return BlockModelShapes.func_209554_c((BlockState)key);
        }
    });
    private static final LoadingCache<Item, ModelResourceLocation> itemLocationCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Item, ModelResourceLocation>(){

        public ModelResourceLocation load(Item key) throws Exception {
            return new ModelResourceLocation(Registry.field_212630_s.func_177774_c((Object)key), "inventory");
        }
    });

    public static ModelResourceLocation get(BlockState state) {
        if (state == null) {
            return null;
        }
        try {
            return (ModelResourceLocation)blockLocationCache.get((Object)state);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static ModelResourceLocation get(Item item) {
        if (item == null) {
            return null;
        }
        try {
            return (ModelResourceLocation)itemLocationCache.get((Object)item);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

