/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.dynresources;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.util.ForwardingInclDefaultsMap;
import org.jetbrains.annotations.Nullable;

public class ModelBakeEventHelper {
    private static final Set<String> INCOMPATIBLE_MODS = ImmutableSet.of((Object)"industrialforegoing", (Object)"mekanism", (Object)"vampirism", (Object)"elevatorid");
    private final Map<ResourceLocation, IBakedModel> modelRegistry;
    private final Set<ResourceLocation> topLevelModelLocations;
    private final MutableGraph<String> dependencyGraph;
    private static final Set<String> WARNED_MOD_IDS = new HashSet<String>();

    public ModelBakeEventHelper(Map<ResourceLocation, IBakedModel> modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.topLevelModelLocations = new HashSet<ResourceLocation>(modelRegistry.keySet());
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation name = block.delegate.name();
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                this.topLevelModelLocations.add((ResourceLocation)BlockModelShapes.func_209553_a((ResourceLocation)name, (BlockState)state));
            }
        }
        ForgeRegistries.ITEMS.getKeys().forEach(key -> this.topLevelModelLocations.add((ResourceLocation)new ModelResourceLocation(key, "inventory")));
        this.dependencyGraph = GraphBuilder.undirected().build();
        ModList.get().forEachModContainer((id, mc) -> {
            this.dependencyGraph.addNode(id);
            for (IModInfo.ModVersion version : mc.getModInfo().getDependencies()) {
                this.dependencyGraph.addNode((Object)version.getModId());
            }
        });
        for (String id2 : this.dependencyGraph.nodes()) {
            Optional mContainer = ModList.get().getModContainerById(id2);
            if (!mContainer.isPresent()) continue;
            for (IModInfo.ModVersion version : ((ModContainer)mContainer.get()).getModInfo().getDependencies()) {
                if (Objects.equals(id2, version.getModId())) continue;
                this.dependencyGraph.putEdge((Object)id2, (Object)version.getModId());
            }
        }
    }

    private Map<ResourceLocation, IBakedModel> createWarningRegistry(final String modId) {
        return new ForwardingInclDefaultsMap<ResourceLocation, IBakedModel>(){

            protected Map<ResourceLocation, IBakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            private void logWarning() {
                if (!WARNED_MOD_IDS.add(modId)) {
                    return;
                }
                ModernFix.LOGGER.warn("Mod '{}' is accessing Map#keySet/entrySet/values/replaceAll on the model registry map inside its event handler. This probably won't work as expected with dynamic resources on. Prefer using Map#get/put and constructing ModelResourceLocations another way.", (Object)modId);
            }

            public Set<ResourceLocation> keySet() {
                this.logWarning();
                return super.keySet();
            }

            public Set<Map.Entry<ResourceLocation, IBakedModel>> entrySet() {
                this.logWarning();
                return super.entrySet();
            }

            public Collection<IBakedModel> values() {
                this.logWarning();
                return super.values();
            }

            @Override
            public void replaceAll(BiFunction<? super ResourceLocation, ? super IBakedModel, ? extends IBakedModel> function) {
                this.logWarning();
                super.replaceAll(function);
            }
        };
    }

    public Map<ResourceLocation, IBakedModel> wrapRegistry(final String modId) {
        final HashSet<String> modIdsToInclude = new HashSet<String>();
        modIdsToInclude.add(modId);
        try {
            modIdsToInclude.addAll(this.dependencyGraph.adjacentNodes((Object)modId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modIdsToInclude.remove("minecraft");
        if (modIdsToInclude.stream().noneMatch(INCOMPATIBLE_MODS::contains)) {
            return this.createWarningRegistry(modId);
        }
        final Set ourModelLocations = Sets.filter(this.topLevelModelLocations, loc -> modIdsToInclude.contains(loc.func_110624_b()));
        final IBakedModel missingModel = this.modelRegistry.get(ModelBakery.field_177604_a);
        return new ForwardingMap<ResourceLocation, IBakedModel>(){

            protected Map<ResourceLocation, IBakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            public IBakedModel get(@Nullable Object key) {
                IBakedModel model = (IBakedModel)super.get(key);
                if (model == null && key != null && modIdsToInclude.contains(((ResourceLocation)key).func_110624_b())) {
                    ModernFix.LOGGER.warn("Model {} is missing, but was requested in model bake event. Returning missing model", key);
                    return missingModel;
                }
                return model;
            }

            public Set<ResourceLocation> keySet() {
                return ourModelLocations;
            }

            public boolean containsKey(@Nullable Object key) {
                return ourModelLocations.contains(key) || super.containsKey(key);
            }

            public void replaceAll(BiFunction<? super ResourceLocation, ? super IBakedModel, ? extends IBakedModel> function) {
                ModernFix.LOGGER.warn("Mod '{}' is calling replaceAll on the model registry. Some hacks will be used to keep this fast, but they may not be 100% compatible.", (Object)modId);
                ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>(this.keySet());
                for (ResourceLocation location : locations) {
                    IBakedModel existing;
                    IBakedModel replacement;
                    boolean needsReplacement;
                    try {
                        needsReplacement = function.apply((ResourceLocation)location, null) != null;
                    }
                    catch (Throwable e) {
                        needsReplacement = true;
                    }
                    if (!needsReplacement || (replacement = function.apply((ResourceLocation)location, (IBakedModel)(existing = this.get(location)))) == existing) continue;
                    this.put(location, replacement);
                }
            }
        };
    }
}

