/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.forge.config.NightConfigFixer;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;

public class ModernFixClientForge {
    private static ModernFixClient commonMod;
    private KeyBinding configKey;
    private static final List<String> brandingList;

    public ModernFixClientForge() {
        commonMod = new ModernFixClient();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ModernFixConfigScreen((Screen)screen));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.configKey = new KeyBinding("key.modernfix.config", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.field_197958_a, "key.modernfix");
        ClientRegistry.registerKeyBinding((KeyBinding)this.configKey);
        if (ModernFixMixinPlugin.instance.isOptionEnabled("perf.dynamic_resources.ConnectednessCheck") && ModList.get().isLoaded("connectedness")) {
            event.enqueueWork(() -> ModLoader.get().addWarning(new ModLoadingWarning(ModLoadingContext.get().getActiveContainer().getModInfo(), ModLoadingStage.SIDED_SETUP, "modernfix.connectedness_dynresoruces", new Object[0])));
        }
    }

    @SubscribeEvent
    public void onConfigKey(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.configKey != null && this.configKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ModernFixConfigScreen(Minecraft.func_71410_x().field_71462_r));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onClientChat(ClientChatEvent event) {
        if (event.getMessage() != null && event.getMessage().trim().equals("/mfrc")) {
            NightConfigFixer.runReloads();
            event.setCanceled(true);
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(event.getMessage());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        if (ModernFixClientForge.commonMod.brandingString != null && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            int targetIdx;
            if (brandingList.size() == 0) {
                brandingList.add("");
                brandingList.add(ModernFixClientForge.commonMod.brandingString);
            }
            int numSeenBlanks = 0;
            ArrayList right = event.getRight();
            for (targetIdx = 0; targetIdx < right.size(); ++targetIdx) {
                String s = (String)right.get(targetIdx);
                if (s == null || s.length() == 0) {
                    ++numSeenBlanks;
                }
                if (numSeenBlanks == 3) break;
            }
            right.addAll(targetIdx, brandingList);
        }
    }

    @SubscribeEvent
    public void onDisconnect(WorldEvent.Unload event) {
        DebugOverlayGui overlay;
        if (event.getWorld().func_201670_d() && (overlay = (DebugOverlayGui)ObfuscationReflectionHelper.getPrivateValue(ForgeIngameGui.class, (Object)((ForgeIngameGui)Minecraft.func_71410_x().field_71456_v), (String)"debugOverlay")) != null) {
            Minecraft.func_71410_x().func_212871_a_(() -> ((DebugOverlayGui)overlay).func_212921_a());
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartedEvent event) {
        commonMod.onServerStarted(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            commonMod.onRenderTickEnd();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRecipes(RecipesUpdatedEvent e) {
        commonMod.onRecipesUpdated();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTags(TagsUpdatedEvent e) {
        commonMod.onTagsUpdated();
    }

    static {
        brandingList = new ArrayList<String>();
    }
}

