/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.load;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.minecraftforge.fml.ModWorkManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ModWorkManagerQueue
extends ConcurrentLinkedDeque<Runnable> {
    private static final long PARK_TIME = TimeUnit.MILLISECONDS.toNanos(25L);
    private static final Runnable DUMMY_TASK = () -> {};
    private boolean shouldReturnDummyTask = false;

    @Override
    public Runnable pollFirst() {
        Runnable r = (Runnable)super.pollFirst();
        if (r == null) {
            LockSupport.parkNanos(PARK_TIME);
            boolean isReturning = this.shouldReturnDummyTask;
            this.shouldReturnDummyTask = !this.shouldReturnDummyTask;
            return isReturning ? DUMMY_TASK : null;
        }
        return r;
    }

    public static void replace() {
        try {
            Runnable task;
            Class<?> syncExecutorClass = Class.forName("net.minecraftforge.fml.ModWorkManager$SyncExecutor");
            ConcurrentLinkedDeque taskQueue = (ConcurrentLinkedDeque)ObfuscationReflectionHelper.getPrivateValue(syncExecutorClass, (Object)ModWorkManager.syncExecutor(), (String)"tasks");
            ModWorkManagerQueue q = new ModWorkManagerQueue();
            do {
                if ((task = (Runnable)taskQueue.pollFirst()) == null) continue;
                q.push(task);
            } while (task != null);
            ObfuscationReflectionHelper.setPrivateValue(syncExecutorClass, (Object)ModWorkManager.syncExecutor(), (Object)q, (String)"tasks");
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

