/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.resourcepacks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.locating.IModFile;
import org.embeddedt.modernfix.resources.ICachingResourcePack;
import org.embeddedt.modernfix.resources.PackResourcesCacheEngine;
import org.embeddedt.modernfix.util.PackTypeHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ModFileResourcePack.class})
public abstract class ModFileResourcePackMixin
implements ICachingResourcePack {
    @Shadow(remap=false)
    @Final
    private ModFile modFile;
    private PackResourcesCacheEngine cacheEngine;

    @Shadow
    public abstract Set<String> func_195759_a(ResourcePackType var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void cacheResources(ModFile modFile, CallbackInfo ci) {
        this.invalidateCache();
        PackResourcesCacheEngine.track(this);
    }

    @Override
    public void invalidateCache() {
        this.cacheEngine = null;
        this.cacheEngine = new PackResourcesCacheEngine(this::func_195759_a, (type, namespace) -> this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{type.func_198956_a(), namespace}));
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCacheForNamespaces(ResourcePackType type, CallbackInfoReturnable<Set<String>> cir) {
        Set<String> namespaces;
        if (this.cacheEngine != null && (namespaces = this.cacheEngine.getNamespaces(type)) != null) {
            cir.setReturnValue(namespaces);
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCacheForExistence(String path, CallbackInfoReturnable<Boolean> cir) {
        if (this.cacheEngine != null && (path.startsWith("assets/") || path.startsWith("data/"))) {
            cir.setReturnValue((Object)this.cacheEngine.hasResource(path));
        }
    }

    @Inject(method={"getResource(Ljava/lang/String;)Ljava/io/InputStream;"}, at={@At(value="INVOKE", target="Ljava/nio/file/Files;exists(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void fasterGetResource(String resourcePath, CallbackInfoReturnable<InputStream> cir, Path path) throws IOException {
        try {
            cir.setReturnValue((Object)Files.newInputStream(path, StandardOpenOption.READ));
        }
        catch (NoSuchFileException e) {
            throw new ResourcePackFileNotFoundException(this.modFile.getFilePath().toFile(), resourcePath);
        }
    }

    @Inject(method={"getResources"}, at={@At(value="HEAD")}, cancellable=true)
    private void fastGetResources(ResourcePackType type, String resourceNamespace, String pathIn, int maxDepth, Predicate<String> filter, CallbackInfoReturnable<Collection<ResourceLocation>> cir) {
        if (!PackTypeHelper.isVanillaPackType(type) || this.cacheEngine == null) {
            return;
        }
        cir.setReturnValue(this.cacheEngine.getResources(type, resourceNamespace, pathIn, maxDepth, filter));
    }
}

